'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CredentialDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onUsernameChange', 'onPasswordChange', 'onRememberChange', 'focusFirstInput');

    this.state = {
      username: '',
      password: '',
      remember: false
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Credentials modal native-key-bindings' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Credentials' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.confirm })
      ),
      _react2.default.createElement(
        'header',
        { className: 'github-DialogPrompt' },
        this.props.prompt
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        this.props.includeUsername ? _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Username:',
          _react2.default.createElement('input', {
            type: 'text',
            ref: e => this.usernameInput = e,
            className: 'input-text github-CredentialDialog-Username',
            value: this.state.username,
            onChange: this.onUsernameChange,
            tabIndex: '1'
          })
        ) : null,
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel' },
          'Password:',
          _react2.default.createElement('input', {
            type: 'password',
            ref: e => this.passwordInput = e,
            className: 'input-text github-CredentialDialog-Password',
            value: this.state.password,
            onChange: this.onPasswordChange,
            tabIndex: '2'
          })
        )
      ),
      _react2.default.createElement(
        'footer',
        { className: 'github-DialogButtons' },
        this.props.includeRemember ? _react2.default.createElement(
          'label',
          { className: 'github-DialogButtons-leftItem input-label' },
          _react2.default.createElement('input', {
            className: 'github-CredentialDialog-remember input-checkbox',
            type: 'checkbox',
            checked: this.state.remember,
            onChange: this.onRememberChange
          }),
          'Remember'
        ) : null,
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', tabIndex: '3', onClick: this.cancel },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', tabIndex: '4', onClick: this.confirm },
          'Sign in'
        )
      )
    );
  }

  confirm() {
    const payload = { password: this.state.password };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    if (this.props.includeRemember) {
      payload.remember = this.state.remember;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({ username: e.target.value });
  }

  onPasswordChange(e) {
    this.setState({ password: e.target.value });
  }

  onRememberChange(e) {
    this.setState({ remember: e.target.checked });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }
}
exports.default = CredentialDialog;
CredentialDialog.propTypes = {
  commandRegistry: _propTypes2.default.object.isRequired,
  prompt: _propTypes2.default.string.isRequired,
  includeUsername: _propTypes2.default.bool,
  includeRemember: _propTypes2.default.bool,
  onSubmit: _propTypes2.default.func,
  onCancel: _propTypes2.default.func
};
CredentialDialog.defaultProps = {
  includeUsername: false,
  includeRemember: false,
  onSubmit: () => {},
  onCancel: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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