'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CreatePullRequestTile extends _react2.default.Component {

  render() {
    if (this.isRepositoryNotFound()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        _react2.default.createElement(
          'strong',
          null,
          'Repository not found'
        ),
        ' for the remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'link' }),
        'Do you need to update your ',
        _react2.default.createElement(
          'strong',
          null,
          'remote URL'
        ),
        '?'
      );
    }

    if (this.isDetachedHead()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'You are not currently on ',
        _react2.default.createElement(
          'strong',
          null,
          'any branch'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-branch' }),
        _react2.default.createElement(
          'strong',
          null,
          'Create a new branch'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    if (this.hasNoDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'The repository at remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        ' is ',
        _react2.default.createElement(
          'strong',
          null,
          'empty'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'arrow-up' }),
        _react2.default.createElement(
          'strong',
          null,
          'Push a main branch'
        ),
        ' to begin sharing your work.'
      );
    }

    if (this.isOnDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'You are currently on your repository\'s ',
        _react2.default.createElement(
          'strong',
          null,
          'default branch'
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-branch' }),
        _react2.default.createElement(
          'strong',
          null,
          'Checkout or create a new branch'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    if (this.isSameAsDefaultRef()) {
      return _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'Your current branch ',
        _react2.default.createElement(
          'strong',
          null,
          'has not moved'
        ),
        ' from the repository\'s default branch.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'git-commit' }),
        _react2.default.createElement(
          'strong',
          null,
          'Make some commits'
        ),
        '\xA0 to share your work with a pull request.'
      );
    }

    let message = 'Open new pull request';
    let disable = false;
    const differentRemote = this.pushesToDifferentRemote();
    if (this.props.pushInProgress) {
      message = 'Pushing...';
      disable = true;
    } else if (!this.hasUpstreamBranch() || differentRemote) {
      message = 'Publish + open new pull request';
    } else if (this.props.aheadCount > 0) {
      message = 'Push + open new pull request';
    }

    return _react2.default.createElement(
      'div',
      null,
      differentRemote && _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-message' },
        'Your current branch is ',
        _react2.default.createElement(
          'strong',
          null,
          'configured'
        ),
        ' to push to the remote ',
        _react2.default.createElement(
          'code',
          null,
          this.props.branches.getHeadBranch().getPush().getRemoteName()
        ),
        '.',
        _react2.default.createElement('hr', { className: 'github-CreatePullRequestTile-divider' }),
        _react2.default.createElement(_octicon2.default, { icon: 'cloud-upload' }),
        _react2.default.createElement(
          'strong',
          null,
          'Publish'
        ),
        ' it to ',
        _react2.default.createElement(
          'code',
          null,
          this.props.remote.getName()
        ),
        ' instead?'
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-CreatePullRequestTile-controls' },
        _react2.default.createElement(
          'button',
          {
            className: 'github-CreatePullRequestTile-createPr btn btn-primary',
            onClick: this.props.onCreatePr,
            disabled: disable },
          message
        )
      )
    );
  }

  isRepositoryNotFound() {
    return !this.props.repository;
  }

  isDetachedHead() {
    return !this.props.branches.getHeadBranch().isPresent();
  }

  hasNoDefaultRef() {
    return !this.props.repository.defaultBranchRef;
  }

  isOnDefaultRef() {
    if (!this.props.repository) {
      return false;
    }
    const defaultRef = this.props.repository.defaultBranchRef;
    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    return currentBranch.getPush().getRemoteRef() === `${defaultRef.prefix}${defaultRef.name}`;
  }

  isSameAsDefaultRef() {
    if (!this.props.repository) {
      return false;
    }
    const defaultRef = this.props.repository.defaultBranchRef;
    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    const mainBranches = this.props.branches.getPushSources(this.props.remote.getName(), `${defaultRef.prefix}${defaultRef.name}`);
    return mainBranches.some(branch => branch.getSha() === currentBranch.getSha());
  }

  pushesToDifferentRemote() {
    const p = this.props.branches.getHeadBranch().getPush();
    if (!p.isRemoteTracking()) {
      return false;
    }

    const pushRemoteName = p.getRemoteName();
    return pushRemoteName !== this.props.remote.getName();
  }

  hasUpstreamBranch() {
    return this.props.branches.getHeadBranch().getUpstream().isPresent();
  }
}
exports.default = CreatePullRequestTile;
CreatePullRequestTile.propTypes = {
  repository: _propTypes2.default.shape({
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  remote: _propTypes3.RemotePropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onCreatePr: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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