'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _reactSelect = require('react-select');

var _reactSelect2 = _interopRequireDefault(_reactSelect);

var _tooltip = require('../atom/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _atomTextEditor = require('../atom/atom-text-editor');

var _atomTextEditor2 = _interopRequireDefault(_atomTextEditor);

var _coAuthorForm = require('./co-author-form');

var _coAuthorForm2 = _interopRequireDefault(_coAuthorForm);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _author = require('../models/author');

var _author2 = _interopRequireDefault(_author);

var _observeModel = require('./observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TOOLTIP_DELAY = 200;

// CustomEvent is a DOM primitive, which v8 can't access
// so we're essentially lazy loading to keep snapshotting from breaking.
let FakeKeyDownEvent;

class CommitView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'submitNewCoAuthor', 'cancelNewCoAuthor', 'didMoveCursor', 'toggleHardWrap', 'toggleCoAuthorInput', 'abortMerge', 'commit', 'amendLastCommit', 'toggleExpandedCommitMessageEditor', 'renderCoAuthorListItem', 'onSelectedCoAuthorsChanged', 'excludeCoAuthor');

    this.state = {
      showWorking: false,
      showCoAuthorInput: false,
      showCoAuthorForm: false,
      coAuthorInput: ''
    };

    this.timeoutHandle = null;
    this.subscriptions = new _eventKit.CompositeDisposable();

    this.refRoot = new _refHolder2.default();
    this.refCommitPreviewButton = new _refHolder2.default();
    this.refExpandButton = new _refHolder2.default();
    this.refCommitButton = new _refHolder2.default();
    this.refHardWrapButton = new _refHolder2.default();
    this.refAbortMergeButton = new _refHolder2.default();
    this.refCoAuthorToggle = new _refHolder2.default();
    this.refCoAuthorSelect = new _refHolder2.default();
    this.refCoAuthorForm = new _refHolder2.default();
    this.refEditorComponent = new _refHolder2.default();
    this.refEditorModel = new _refHolder2.default();

    this.subs = new _eventKit.CompositeDisposable();
  }

  proxyKeyCode(keyCode) {
    return e => {
      if (this.refCoAuthorSelect.isEmpty()) {
        return;
      }

      if (!FakeKeyDownEvent) {
        FakeKeyDownEvent = class extends CustomEvent {
          constructor(kCode) {
            super('keydown');
            this.keyCode = kCode;
          }
        };
      }

      const fakeEvent = new FakeKeyDownEvent(keyCode);
      this.refCoAuthorSelect.get().handleKeyDown(fakeEvent);

      if (!fakeEvent.defaultPrevented) {
        e.abortKeyBinding();
      }
    };
  }

  // eslint-disable-next-line camelcase
  UNSAFE_componentWillMount() {
    this.scheduleShowWorking(this.props);

    this.subs.add(this.props.config.onDidChange('github.automaticCommitMessageWrapping', () => this.forceUpdate()), this.props.messageBuffer.onDidChange(() => this.forceUpdate()));
  }

  render() {
    let remainingCharsClassName = '';
    const remainingCharacters = parseInt(this.getRemainingCharacters(), 10);
    if (remainingCharacters < 0) {
      remainingCharsClassName = 'is-error';
    } else if (remainingCharacters < this.props.maximumCharacterLimit / 4) {
      remainingCharsClassName = 'is-warning';
    }

    const showAbortMergeButton = this.props.isMerging || null;

    /* istanbul ignore next */
    const modKey = process.platform === 'darwin' ? 'Cmd' : 'Ctrl';

    return _react2.default.createElement(
      'div',
      { className: 'github-CommitView', ref: this.refRoot.setter },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:commit', callback: this.commit }),
        _react2.default.createElement(_commands.Command, { command: 'github:amend-last-commit', callback: this.amendLastCommit }),
        _react2.default.createElement(_commands.Command, { command: 'github:toggle-expanded-commit-message-editor',
          callback: this.toggleExpandedCommitMessageEditor
        })
      ),
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-CommitView-coAuthorEditor' },
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:down', callback: this.proxyKeyCode(40) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:up', callback: this.proxyKeyCode(38) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:enter', callback: this.proxyKeyCode(13) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:tab', callback: this.proxyKeyCode(9) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:backspace', callback: this.proxyKeyCode(8) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:pageup', callback: this.proxyKeyCode(33) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:pagedown', callback: this.proxyKeyCode(34) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:end', callback: this.proxyKeyCode(35) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:home', callback: this.proxyKeyCode(36) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:delete', callback: this.proxyKeyCode(46) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author:escape', callback: this.proxyKeyCode(27) }),
        _react2.default.createElement(_commands.Command, { command: 'github:co-author-exclude', callback: this.excludeCoAuthor })
      ),
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-CommitView-commitPreview' },
        _react2.default.createElement(_commands.Command, { command: 'github:dive', callback: this.props.activateCommitPreview })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-CommitView-buttonWrapper' },
        _react2.default.createElement(
          'button',
          {
            ref: this.refCommitPreviewButton.setter,
            className: 'github-CommitView-commitPreview github-CommitView-button btn',
            disabled: !this.props.stagedChangesExist,
            onClick: this.props.toggleCommitPreview },
          this.props.commitPreviewActive ? 'Hide All Staged Changes' : 'See All Staged Changes'
        )
      ),
      _react2.default.createElement(
        'div',
        { className: (0, _classnames2.default)('github-CommitView-editor', { 'is-expanded': this.props.deactivateCommitBox }) },
        _react2.default.createElement(_atomTextEditor2.default, {
          ref: this.refEditorComponent.setter,
          refModel: this.refEditorModel,
          softWrapped: true,
          placeholderText: 'Commit message',
          lineNumberGutterVisible: false,
          showInvisibles: false,
          autoHeight: false,
          scrollPastEnd: false,
          buffer: this.props.messageBuffer,
          workspace: this.props.workspace,
          didChangeCursorPosition: this.didMoveCursor
        }),
        _react2.default.createElement(
          'button',
          {
            ref: this.refCoAuthorToggle.setter,
            className: (0, _classnames2.default)('github-CommitView-coAuthorToggle', { focused: this.state.showCoAuthorInput }),
            onClick: this.toggleCoAuthorInput },
          this.renderCoAuthorToggleIcon()
        ),
        _react2.default.createElement(_tooltip2.default, {
          manager: this.props.tooltips,
          target: this.refCoAuthorToggle,
          title: `${this.state.showCoAuthorInput ? 'Remove' : 'Add'} co-authors`,
          showDelay: TOOLTIP_DELAY
        }),
        _react2.default.createElement(
          'button',
          {
            ref: this.refHardWrapButton.setter,
            onClick: this.toggleHardWrap,
            className: 'github-CommitView-hardwrap hard-wrap-icons' },
          this.renderHardWrapIcon()
        ),
        _react2.default.createElement(_tooltip2.default, {
          manager: this.props.tooltips,
          target: this.refHardWrapButton,
          className: 'github-CommitView-hardwrap-tooltip',
          title: 'Toggle hard wrap on commit',
          showDelay: TOOLTIP_DELAY
        }),
        _react2.default.createElement('button', {
          ref: this.refExpandButton.setter,
          className: 'github-CommitView-expandButton icon icon-screen-full',
          onClick: this.toggleExpandedCommitMessageEditor
        }),
        _react2.default.createElement(_tooltip2.default, {
          manager: this.props.tooltips,
          target: this.refExpandButton,
          className: 'github-CommitView-expandButton-tooltip',
          title: 'Expand commit message editor',
          showDelay: TOOLTIP_DELAY
        })
      ),
      this.renderCoAuthorForm(),
      this.renderCoAuthorInput(),
      _react2.default.createElement(
        'footer',
        { className: 'github-CommitView-bar' },
        showAbortMergeButton && _react2.default.createElement(
          'button',
          {
            ref: this.refAbortMergeButton.setter,
            className: 'btn github-CommitView-button github-CommitView-abortMerge is-secondary',
            onClick: this.abortMerge },
          'Abort Merge'
        ),
        _react2.default.createElement(
          'button',
          {
            ref: this.refCommitButton.setter,
            className: 'github-CommitView-button github-CommitView-commit btn btn-primary native-key-bindings',
            onClick: this.commit,
            disabled: !this.commitIsEnabled(false) },
          this.commitButtonText()
        ),
        this.commitIsEnabled(false) && _react2.default.createElement(_tooltip2.default, {
          manager: this.props.tooltips,
          target: this.refCommitButton,
          className: 'github-CommitView-button-tooltip',
          title: `${modKey}-enter to commit`,
          showDelay: TOOLTIP_DELAY
        }),
        _react2.default.createElement(
          'div',
          { className: `github-CommitView-remaining-characters ${remainingCharsClassName}` },
          this.getRemainingCharacters()
        )
      )
    );
  }

  renderCoAuthorToggleIcon() {
    /* eslint-disable max-len */
    const svgPath = 'M9.875 2.125H12v1.75H9.875V6h-1.75V3.875H6v-1.75h2.125V0h1.75v2.125zM6 6.5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5V6c0-1.316 2-2 2-2s.114-.204 0-.5c-.42-.31-.472-.795-.5-2C1.587.293 2.434 0 3 0s1.413.293 1.5 1.5c-.028 1.205-.08 1.69-.5 2-.114.295 0 .5 0 .5s2 .684 2 2v.5z';
    return _react2.default.createElement(
      'svg',
      { className: (0, _classnames2.default)('github-CommitView-coAuthorToggleIcon', { focused: this.state.showCoAuthorInput }), viewBox: '0 0 12 7', xmlns: 'http://www.w3.org/2000/svg' },
      _react2.default.createElement(
        'title',
        null,
        'Add or remove co-authors'
      ),
      _react2.default.createElement('path', { d: svgPath })
    );
  }

  renderCoAuthorInput() {
    if (!this.state.showCoAuthorInput) {
      return null;
    }

    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.userStore, fetchData: store => store.getUsers() },
      mentionableUsers => _react2.default.createElement(_reactSelect2.default, {
        ref: this.refCoAuthorSelect.setter,
        className: 'github-CommitView-coAuthorEditor input-textarea native-key-bindings',
        placeholder: 'Co-Authors',
        arrowRenderer: null,
        options: mentionableUsers,
        labelKey: 'fullName',
        valueKey: 'email',
        filterOptions: this.matchAuthors,
        optionRenderer: this.renderCoAuthorListItem,
        valueRenderer: this.renderCoAuthorValue,
        onChange: this.onSelectedCoAuthorsChanged,
        value: this.props.selectedCoAuthors,
        multi: true,
        openOnClick: false,
        openOnFocus: false,
        tabIndex: '5'
      })
    );
  }

  renderHardWrapIcon() {
    const singleLineMessage = this.props.messageBuffer.getText().split(_helpers.LINE_ENDING_REGEX).length === 1;
    const hardWrap = this.props.config.get('github.automaticCommitMessageWrapping');
    const notApplicable = this.props.deactivateCommitBox || singleLineMessage;

    /* eslint-disable max-len */
    const svgPaths = {
      hardWrapEnabled: {
        path1: 'M7.058 10.2h-.975v2.4L2 9l4.083-3.6v2.4h.97l1.202 1.203L7.058 10.2zm2.525-4.865V4.2h2.334v1.14l-1.164 1.165-1.17-1.17z', // eslint-disable-line max-len
        path2: 'M7.842 6.94l2.063 2.063-2.122 2.12.908.91 2.123-2.123 1.98 1.98.85-.848L11.58 8.98l2.12-2.123-.824-.825-2.122 2.12-2.062-2.06z' // eslint-disable-line max-len
      },
      hardWrapDisabled: {
        path1: 'M11.917 8.4c0 .99-.788 1.8-1.75 1.8H6.083v2.4L2 9l4.083-3.6v2.4h3.5V4.2h2.334v4.2z'
      }
    };
    /* eslint-enable max-line */

    if (notApplicable) {
      return null;
    }

    if (hardWrap) {
      return _react2.default.createElement(
        'div',
        { className: (0, _classnames2.default)('icon', 'hardwrap', 'icon-hardwrap-enabled', { hidden: notApplicable || !hardWrap }) },
        _react2.default.createElement(
          'svg',
          { width: '16', height: '16', viewBox: '0 0 16 16', xmlns: 'http://www.w3.org/2000/svg' },
          _react2.default.createElement('path', { d: svgPaths.hardWrapDisabled.path1, fillRule: 'evenodd' })
        )
      );
    } else {
      return _react2.default.createElement(
        'div',
        { className: (0, _classnames2.default)('icon', 'no-hardwrap', 'icon-hardwrap-disabled', { hidden: notApplicable || hardWrap }) },
        _react2.default.createElement(
          'svg',
          { width: '16', height: '16', viewBox: '0 0 16 16', xmlns: 'http://www.w3.org/2000/svg' },
          _react2.default.createElement(
            'g',
            { fillRule: 'evenodd' },
            _react2.default.createElement('path', { d: svgPaths.hardWrapEnabled.path1 }),
            _react2.default.createElement('path', { fillRule: 'nonzero', d: svgPaths.hardWrapEnabled.path2 })
          )
        )
      );
    }
  }

  renderCoAuthorForm() {
    if (!this.state.showCoAuthorForm) {
      return null;
    }

    return _react2.default.createElement(_coAuthorForm2.default, {
      ref: this.refCoAuthorForm.setter,
      commandRegistry: this.props.commandRegistry,
      onSubmit: this.submitNewCoAuthor,
      onCancel: this.cancelNewCoAuthor,
      name: this.state.coAuthorInput
    });
  }

  submitNewCoAuthor(newAuthor) {
    this.props.updateSelectedCoAuthors(this.props.selectedCoAuthors, newAuthor);
    this.hideNewAuthorForm();
  }

  cancelNewCoAuthor() {
    this.hideNewAuthorForm();
  }

  hideNewAuthorForm() {
    this.setState({ showCoAuthorForm: false }, () => {
      this.refCoAuthorSelect.map(c => c.focus());
    });
  }

  // eslint-disable-next-line camelcase
  UNSAFE_componentWillReceiveProps(nextProps) {
    this.scheduleShowWorking(nextProps);
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  didMoveCursor() {
    this.forceUpdate();
  }

  toggleHardWrap() {
    const currentSetting = this.props.config.get('github.automaticCommitMessageWrapping');
    this.props.config.set('github.automaticCommitMessageWrapping', !currentSetting);
  }

  toggleCoAuthorInput() {
    this.setState({
      showCoAuthorInput: !this.state.showCoAuthorInput
    }, () => {
      if (this.state.showCoAuthorInput) {
        (0, _reporterProxy.incrementCounter)('show-co-author-input');
        this.refCoAuthorSelect.map(c => c.focus());
      } else {
        // if input is closed, remove all co-authors
        this.props.updateSelectedCoAuthors([]);
        (0, _reporterProxy.incrementCounter)('hide-co-author-input');
      }
    });
  }

  excludeCoAuthor() {
    const author = this.refCoAuthorSelect.map(c => c.getFocusedOption()).getOr(null);
    if (!author || author.isNew()) {
      return;
    }

    let excluded = this.props.config.get('github.excludedUsers');
    if (excluded && excluded !== '') {
      excluded += ', ';
    }
    excluded += author.getEmail();
    this.props.config.set('github.excludedUsers', excluded);
  }

  abortMerge() {
    this.props.abortMerge();
  }

  async commit(event, amend) {
    if ((await this.props.prepareToCommit()) && this.commitIsEnabled(amend)) {
      try {
        await this.props.commit(this.props.messageBuffer.getText(), this.props.selectedCoAuthors, amend);
      } catch (e) {
        // do nothing - error was taken care of in pipeline manager
        if (!atom.isReleasedVersion()) {
          throw e;
        }
      }
    } else {
      this.setFocus(CommitView.focus.EDITOR);
    }
  }

  amendLastCommit() {
    (0, _reporterProxy.incrementCounter)('amend');
    this.commit(null, true);
  }

  getRemainingCharacters() {
    return this.refEditorModel.map(editor => {
      if (editor.getCursorBufferPosition().row === 0) {
        return (this.props.maximumCharacterLimit - editor.lineTextForBufferRow(0).length).toString();
      } else {
        return '∞';
      }
    }).getOr(this.props.maximumCharacterLimit || '');
  }

  // We don't want the user to see the UI flicker in the case
  // the commit takes a very small time to complete. Instead we
  // will only show the working message if we are working for longer
  // than 1 second as per https://www.nngroup.com/articles/response-times-3-important-limits/
  //
  // The closure is created to restrict variable access
  scheduleShowWorking(props) {
    if (props.isCommitting) {
      if (!this.state.showWorking && this.timeoutHandle === null) {
        this.timeoutHandle = setTimeout(() => {
          this.timeoutHandle = null;
          this.setState({ showWorking: true });
        }, 1000);
      }
    } else {
      clearTimeout(this.timeoutHandle);
      this.timeoutHandle = null;
      this.setState({ showWorking: false });
    }
  }

  isValidMessage() {
    // ensure that there are at least some non-comment lines in the commit message.
    // Commented lines are stripped out of commit messages by git, by default configuration.
    return this.props.messageBuffer.getText().replace(/^#.*$/gm, '').trim().length !== 0;
  }

  commitIsEnabled(amend) {
    return !this.props.isCommitting && (amend || this.props.stagedChangesExist) && !this.props.mergeConflictsExist && this.props.lastCommit.isPresent() && (this.props.deactivateCommitBox || amend || this.isValidMessage());
  }

  commitButtonText() {
    if (this.state.showWorking) {
      return 'Working...';
    } else if (this.props.currentBranch.isDetached()) {
      return 'Create detached commit';
    } else if (this.props.currentBranch.isPresent()) {
      return `Commit to ${this.props.currentBranch.getName()}`;
    } else {
      return 'Commit';
    }
  }

  toggleExpandedCommitMessageEditor() {
    return this.props.toggleExpandedCommitMessageEditor(this.props.messageBuffer.getText());
  }

  matchAuthors(authors, filterText, selectedAuthors) {
    const matchedAuthors = authors.filter((author, index) => {
      const isAlreadySelected = selectedAuthors && selectedAuthors.find(selected => selected.matches(author));
      const matchesFilter = [author.getLogin(), author.getFullName(), author.getEmail()].some(field => field && field.toLowerCase().indexOf(filterText.toLowerCase()) !== -1);

      return !isAlreadySelected && matchesFilter;
    });
    matchedAuthors.push(_author2.default.createNew('Add new author', filterText));
    return matchedAuthors;
  }

  renderCoAuthorListItemField(fieldName, value) {
    if (!value || value.length === 0) {
      return null;
    }

    return _react2.default.createElement(
      'span',
      { className: `github-CommitView-coAuthorEditor-${fieldName}` },
      value
    );
  }

  renderCoAuthorListItem(author) {
    return _react2.default.createElement(
      'div',
      { className: (0, _classnames2.default)('github-CommitView-coAuthorEditor-selectListItem', { 'new-author': author.isNew() }) },
      this.renderCoAuthorListItemField('name', author.getFullName()),
      author.hasLogin() && this.renderCoAuthorListItemField('login', '@' + author.getLogin()),
      this.renderCoAuthorListItemField('email', author.getEmail())
    );
  }

  renderCoAuthorValue(author) {
    const fullName = author.getFullName();
    if (fullName && fullName.length > 0) {
      return _react2.default.createElement(
        'span',
        null,
        author.getFullName()
      );
    }
    if (author.hasLogin()) {
      return _react2.default.createElement(
        'span',
        null,
        '@',
        author.getLogin()
      );
    }

    return _react2.default.createElement(
      'span',
      null,
      author.getEmail()
    );
  }

  onSelectedCoAuthorsChanged(selectedCoAuthors) {
    (0, _reporterProxy.incrementCounter)('selected-co-authors-changed');
    const newAuthor = selectedCoAuthors.find(author => author.isNew());

    if (newAuthor) {
      this.setState({ coAuthorInput: newAuthor.getFullName(), showCoAuthorForm: true });
    } else {
      this.props.updateSelectedCoAuthors(selectedCoAuthors);
    }
  }

  hasFocus() {
    return this.refRoot.map(element => element.contains(document.activeElement)).getOr(false);
  }

  hasFocusEditor() {
    return this.refEditorComponent.map(editor => editor.contains(document.activeElement)).getOr(false);
  }

  hasFocusAtBeginning() {
    return this.refCommitPreviewButton.map(button => button.contains(document.activeElement)).getOr(false);
  }

  getFocus(element = document.activeElement) {
    if (this.refCommitPreviewButton.map(button => button.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_PREVIEW_BUTTON;
    }

    if (this.refEditorComponent.map(editor => editor.contains(element)).getOr(false)) {
      return CommitView.focus.EDITOR;
    }

    if (this.refAbortMergeButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.ABORT_MERGE_BUTTON;
    }

    if (this.refCommitButton.map(e => e.contains(element)).getOr(false)) {
      return CommitView.focus.COMMIT_BUTTON;
    }

    if (this.refCoAuthorSelect.map(c => c.wrapper && c.wrapper.contains(element)).getOr(false)) {
      return CommitView.focus.COAUTHOR_INPUT;
    }

    return null;
  }

  rememberFocus(event) {
    return this.getFocus(event.target);
  }

  setFocus(focus) {
    let fallback = false;
    const focusElement = element => {
      element.focus();
      return true;
    };

    if (focus === CommitView.focus.COMMIT_PREVIEW_BUTTON) {
      if (this.refCommitPreviewButton.map(focusElement).getOr(false)) {
        return true;
      }
    }

    if (focus === CommitView.focus.EDITOR) {
      if (this.refEditorComponent.map(focusElement).getOr(false)) {
        if (this.props.messageBuffer.getText().length > 0 && !this.isValidMessage()) {
          // there is likely a commit message template present
          // we want the cursor to be at the beginning, not at the and of the template
          this.refEditorComponent.get().getModel().setCursorBufferPosition([0, 0]);
        }
        return true;
      }
    }

    if (focus === CommitView.focus.ABORT_MERGE_BUTTON) {
      if (this.refAbortMergeButton.map(focusElement).getOr(false)) {
        return true;
      }
      fallback = true;
    }

    if (focus === CommitView.focus.COMMIT_BUTTON) {
      if (this.refCommitButton.map(focusElement).getOr(false)) {
        return true;
      }
      fallback = true;
    }

    if (focus === CommitView.focus.COAUTHOR_INPUT) {
      if (this.refCoAuthorSelect.map(focusElement).getOr(false)) {
        return true;
      }
      fallback = true;
    }

    if (fallback && this.refEditorComponent.map(focusElement).getOr(false)) {
      return true;
    }

    return false;
  }

  advanceFocus(event) {
    const f = this.constructor.focus;
    const current = this.getFocus();
    if (current === f.EDITOR) {
      // Let the editor handle it
      return true;
    }

    let next = null;
    switch (current) {
      case f.COMMIT_PREVIEW_BUTTON:
        next = f.EDITOR;
        break;
      case f.COAUTHOR_INPUT:
        next = this.props.isMerging ? f.ABORT_MERGE_BUTTON : f.COMMIT_BUTTON;
        break;
      case f.ABORT_MERGE_BUTTON:
        next = f.COMMIT_BUTTON;
        break;
      case f.COMMIT_BUTTON:
        // End of tab navigation. Prevent cycling.
        event.stopPropagation();
        return true;
    }

    if (next !== null) {
      this.setFocus(next);
      event.stopPropagation();

      return true;
    } else {
      return false;
    }
  }

  retreatFocus(event) {
    const f = this.constructor.focus;
    const current = this.getFocus();

    let next = null;
    switch (current) {
      case f.COMMIT_BUTTON:
        if (this.props.isMerging) {
          next = f.ABORT_MERGE_BUTTON;
        } else if (this.state.showCoAuthorInput) {
          next = f.COAUTHOR_INPUT;
        } else {
          next = f.EDITOR;
        }
        break;
      case f.ABORT_MERGE_BUTTON:
        next = this.state.showCoAuthorInput ? f.COAUTHOR_INPUT : f.EDITOR;
        break;
      case f.COAUTHOR_INPUT:
        next = f.EDITOR;
        break;
      case f.EDITOR:
        next = f.COMMIT_PREVIEW_BUTTON;
        break;
      case f.COMMIT_PREVIEW_BUTTON:
        // Allow the GitTabView to retreat focus back to the last StagingView list.
        return false;
    }

    if (next !== null) {
      this.setFocus(next);
      event.stopPropagation();

      return true;
    } else {
      return false;
    }
  }
}
exports.default = CommitView;
CommitView.focus = {
  COMMIT_PREVIEW_BUTTON: Symbol('commit-preview-button'),
  EDITOR: Symbol('commit-editor'),
  COAUTHOR_INPUT: Symbol('coauthor-input'),
  ABORT_MERGE_BUTTON: Symbol('commit-abort-merge-button'),
  COMMIT_BUTTON: Symbol('commit-button')
};
CommitView.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,

  lastCommit: _propTypes2.default.object.isRequired,
  currentBranch: _propTypes2.default.object.isRequired,
  isMerging: _propTypes2.default.bool.isRequired,
  mergeConflictsExist: _propTypes2.default.bool.isRequired,
  stagedChangesExist: _propTypes2.default.bool.isRequired,
  isCommitting: _propTypes2.default.bool.isRequired,
  commitPreviewActive: _propTypes2.default.bool.isRequired,
  deactivateCommitBox: _propTypes2.default.bool.isRequired,
  maximumCharacterLimit: _propTypes2.default.number.isRequired,
  messageBuffer: _propTypes2.default.object.isRequired, // FIXME more specific proptype
  userStore: _propTypes3.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes2.default.arrayOf(_propTypes3.AuthorPropType),
  updateSelectedCoAuthors: _propTypes2.default.func,
  commit: _propTypes2.default.func.isRequired,
  abortMerge: _propTypes2.default.func.isRequired,
  prepareToCommit: _propTypes2.default.func.isRequired,
  toggleExpandedCommitMessageEditor: _propTypes2.default.func.isRequired,
  toggleCommitPreview: _propTypes2.default.func.isRequired,
  activateCommitPreview: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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