'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _reporterProxy = require('../reporter-proxy');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ChangedFilesCountView extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handleClick');
  }

  handleClick() {
    (0, _reporterProxy.addEvent)('click', { package: 'github', component: 'ChangedFileCountView' });
    this.props.didClick();
  }

  render() {
    return _react2.default.createElement(
      'button',
      {
        ref: 'changedFiles',
        className: 'github-ChangedFilesCount inline-block',
        onClick: this.handleClick },
      _react2.default.createElement(_octicon2.default, { icon: 'git-commit' }),
      `Git (${this.props.changedFilesCount})`,
      this.props.mergeConflictsPresent && _react2.default.createElement(_octicon2.default, { icon: 'alert' })
    );
  }
}
exports.default = ChangedFilesCountView;
ChangedFilesCountView.propTypes = {
  changedFilesCount: _propTypes2.default.number.isRequired,
  didClick: _propTypes2.default.func.isRequired,
  mergeConflictsPresent: _propTypes2.default.bool
};
ChangedFilesCountView.defaultProps = {
  changedFilesCount: 0,
  mergeConflictsPresent: false,
  didClick: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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