'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _propTypes3 = require('../prop-types');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BranchView extends _react2.default.Component {

  render() {
    const classNames = (0, _classnames2.default)('github-branch', 'inline-block', { 'github-branch-detached': this.props.currentBranch.isDetached() });

    return _react2.default.createElement(
      'div',
      { className: classNames, ref: this.props.refRoot },
      _react2.default.createElement('span', { className: 'icon icon-git-branch' }),
      _react2.default.createElement(
        'span',
        { className: 'branch-label' },
        this.props.currentBranch.getName()
      )
    );
  }
}
exports.default = BranchView;
BranchView.propTypes = {
  currentBranch: _propTypes3.BranchPropType.isRequired,
  refRoot: _propTypes2.default.func
};
BranchView.defaultProps = {
  refRoot: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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