'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _propTypes3 = require('../prop-types');

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BranchMenuView extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'didSelectItem', 'createBranch', 'checkout', 'cancelCreateNewBranch');

    this.state = {
      createNew: false,
      checkedOutBranch: null
    };
  }

  render() {
    const branchNames = this.props.branches.getNames();
    let currentBranchName = this.props.currentBranch.isDetached() ? 'detached' : this.props.currentBranch.getName();
    if (this.state.checkedOutBranch) {
      currentBranchName = this.state.checkedOutBranch;
      if (branchNames.indexOf(this.state.checkedOutBranch) === -1) {
        branchNames.push(this.state.checkedOutBranch);
      }
    }

    const disableControls = !!this.state.checkedOutBranch;

    const branchEditorClasses = (0, _classnames2.default)('github-BranchMenuView-item', 'github-BranchMenuView-editor', {
      hidden: !this.state.createNew
    });

    const branchSelectListClasses = (0, _classnames2.default)('github-BranchMenuView-item', 'github-BranchMenuView-select', 'input-select', {
      hidden: !!this.state.createNew
    });

    const iconClasses = (0, _classnames2.default)('github-BranchMenuView-item', 'icon', {
      'icon-git-branch': !disableControls,
      'icon-sync': disableControls
    });

    const newBranchEditor = _react2.default.createElement(
      'div',
      { className: branchEditorClasses },
      _react2.default.createElement('atom-text-editor', {
        ref: e => {
          this.editorElement = e;
        },
        mini: true,
        readonly: disableControls ? true : undefined
      })
    );

    const selectBranchView =
    /* eslint-disable jsx-a11y/no-onchange */
    _react2.default.createElement(
      'select',
      {
        className: branchSelectListClasses,
        onChange: this.didSelectItem,
        disabled: disableControls,
        value: currentBranchName },
      this.props.currentBranch.isDetached() && _react2.default.createElement(
        'option',
        { key: 'detached', value: 'detached', disabled: true },
        this.props.currentBranch.getName()
      ),
      branchNames.map(branchName => {
        return _react2.default.createElement(
          'option',
          { key: branchName, value: branchName },
          branchName
        );
      })
    );

    return _react2.default.createElement(
      'div',
      { className: 'github-BranchMenuView' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-BranchMenuView-editor atom-text-editor[mini]' },
        _react2.default.createElement(_commands.Command, { command: 'tool-panel:unfocus', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancelCreateNewBranch }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.createBranch })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-BranchMenuView-selector' },
        _react2.default.createElement('span', { className: iconClasses }),
        newBranchEditor,
        selectBranchView,
        _react2.default.createElement(
          'button',
          { className: 'github-BranchMenuView-item github-BranchMenuView-button btn',
            onClick: this.createBranch, disabled: disableControls },
          ' New Branch '
        )
      )
    );
  }

  async didSelectItem(event) {
    const branchName = event.target.value;
    await this.checkout(branchName);
  }

  async createBranch() {
    if (this.state.createNew) {
      const branchName = this.editorElement.getModel().getText().trim();
      await this.checkout(branchName, { createNew: true });
    } else {
      await new Promise(resolve => {
        this.setState({ createNew: true }, () => {
          this.editorElement.focus();
          resolve();
        });
      });
    }
  }

  async checkout(branchName, options) {
    this.editorElement.classList.remove('is-focused');
    await new Promise(resolve => {
      this.setState({ checkedOutBranch: branchName }, resolve);
    });
    try {
      await this.props.checkout(branchName, options);
      await new Promise(resolve => {
        this.setState({ checkedOutBranch: null, createNew: false }, resolve);
      });
      this.editorElement.getModel().setText('');
    } catch (error) {
      this.editorElement.classList.add('is-focused');
      await new Promise(resolve => {
        this.setState({ checkedOutBranch: null }, resolve);
      });
      if (!(error instanceof _gitShellOutStrategy.GitError)) {
        throw error;
      }
    }
  }

  cancelCreateNewBranch() {
    this.setState({ createNew: false });
  }
}
exports.default = BranchMenuView;
BranchMenuView.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object,
  branches: _propTypes3.BranchSetPropType.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  checkout: _propTypes2.default.func
};
BranchMenuView.defaultProps = {
  checkout: () => Promise.resolve()
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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