'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserStorePropType = exports.MergeConflictItemPropType = exports.MultiFilePatchPropType = exports.FilePatchItemPropType = exports.IssueishPropType = exports.OperationStateObserverPropType = exports.EnableableOperationPropType = exports.RangePropType = exports.PointPropType = exports.RefHolderPropType = exports.RelayConnectionPropType = exports.AuthorPropType = exports.CommitPropType = exports.BranchSetPropType = exports.RemoteSetPropType = exports.SearchPropType = exports.BranchPropType = exports.RemotePropType = exports.GithubLoginModelPropType = exports.WorkdirContextPoolPropType = exports.DOMNodePropType = undefined;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DOMNodePropType = exports.DOMNodePropType = (props, propName, componentName) => {
  if (props[propName] instanceof HTMLElement) {
    return null;
  } else {
    return new Error(`Invalid prop '${propName}' supplied to '${componentName}'. Value is not DOM element.`);
  }
};

const WorkdirContextPoolPropType = exports.WorkdirContextPoolPropType = _propTypes2.default.shape({
  getContext: _propTypes2.default.func.isRequired
});

const GithubLoginModelPropType = exports.GithubLoginModelPropType = _propTypes2.default.shape({
  getToken: _propTypes2.default.func.isRequired,
  setToken: _propTypes2.default.func.isRequired,
  removeToken: _propTypes2.default.func.isRequired,
  getScopes: _propTypes2.default.func.isRequired,
  onDidUpdate: _propTypes2.default.func.isRequired
});

const RemotePropType = exports.RemotePropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  getUrl: _propTypes2.default.func.isRequired,
  isGithubRepo: _propTypes2.default.func.isRequired,
  getOwner: _propTypes2.default.func.isRequired,
  getRepo: _propTypes2.default.func.isRequired
});

const BranchPropType = exports.BranchPropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  isDetached: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});

const SearchPropType = exports.SearchPropType = _propTypes2.default.shape({
  getName: _propTypes2.default.func.isRequired,
  createQuery: _propTypes2.default.func.isRequired
});

const RemoteSetPropType = exports.RemoteSetPropType = _propTypes2.default.shape({
  withName: _propTypes2.default.func.isRequired,
  isEmpty: _propTypes2.default.func.isRequired,
  size: _propTypes2.default.func.isRequired,
  [Symbol.iterator]: _propTypes2.default.func.isRequired
});

const BranchSetPropType = exports.BranchSetPropType = _propTypes2.default.shape({
  getNames: _propTypes2.default.func.isRequired,
  getPullTargets: _propTypes2.default.func.isRequired,
  getPushSources: _propTypes2.default.func.isRequired
});

const CommitPropType = exports.CommitPropType = _propTypes2.default.shape({
  getSha: _propTypes2.default.func.isRequired,
  getMessageSubject: _propTypes2.default.func.isRequired,
  isUnbornRef: _propTypes2.default.func.isRequired,
  isPresent: _propTypes2.default.func.isRequired
});

const AuthorPropType = exports.AuthorPropType = _propTypes2.default.shape({
  getEmail: _propTypes2.default.func.isRequired,
  getFullName: _propTypes2.default.func.isRequired
});

const RelayConnectionPropType = exports.RelayConnectionPropType = nodePropType => _propTypes2.default.shape({
  edges: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    cursor: _propTypes2.default.string,
    node: nodePropType
  })),
  pageInfo: _propTypes2.default.shape({
    endCursor: _propTypes2.default.string,
    hasNextPage: _propTypes2.default.bool,
    hasPreviousPage: _propTypes2.default.bool,
    startCursor: _propTypes2.default.string
  }),
  totalCount: _propTypes2.default.number
});

const RefHolderPropType = exports.RefHolderPropType = _propTypes2.default.shape({
  isEmpty: _propTypes2.default.func.isRequired,
  get: _propTypes2.default.func.isRequired,
  setter: _propTypes2.default.func.isRequired,
  observe: _propTypes2.default.func.isRequired
});

const PointPropType = exports.PointPropType = _propTypes2.default.shape({
  row: _propTypes2.default.number.isRequired,
  column: _propTypes2.default.number.isRequired,
  isEqual: _propTypes2.default.func.isRequired
});

const RangePropType = exports.RangePropType = _propTypes2.default.shape({
  start: PointPropType.isRequired,
  end: PointPropType.isRequired,
  isEqual: _propTypes2.default.func.isRequired
});

const EnableableOperationPropType = exports.EnableableOperationPropType = _propTypes2.default.shape({
  isEnabled: _propTypes2.default.func.isRequired,
  run: _propTypes2.default.func.isRequired,
  getMessage: _propTypes2.default.func.isRequired,
  why: _propTypes2.default.func.isRequired
});

const OperationStateObserverPropType = exports.OperationStateObserverPropType = _propTypes2.default.shape({
  onDidComplete: _propTypes2.default.func.isRequired,
  dispose: _propTypes2.default.func.isRequired
});

const IssueishPropType = exports.IssueishPropType = _propTypes2.default.shape({
  getNumber: _propTypes2.default.func.isRequired,
  getTitle: _propTypes2.default.func.isRequired,
  getGitHubURL: _propTypes2.default.func.isRequired,
  getAuthorLogin: _propTypes2.default.func.isRequired,
  getAuthorAvatarURL: _propTypes2.default.func.isRequired,
  getCreatedAt: _propTypes2.default.func.isRequired,
  getHeadRefName: _propTypes2.default.func.isRequired,
  getHeadRepositoryID: _propTypes2.default.func.isRequired,
  getStatusCounts: _propTypes2.default.func.isRequired
});

const FilePatchItemPropType = exports.FilePatchItemPropType = _propTypes2.default.shape({
  filePath: _propTypes2.default.string.isRequired,
  status: _propTypes2.default.string.isRequired
});

const MultiFilePatchPropType = exports.MultiFilePatchPropType = _propTypes2.default.shape({
  getFilePatches: _propTypes2.default.func.isRequired
});

const statusNames = ['added', 'deleted', 'modified', 'typechange', 'equivalent'];

const MergeConflictItemPropType = exports.MergeConflictItemPropType = _propTypes2.default.shape({
  filePath: _propTypes2.default.string.isRequired,
  status: _propTypes2.default.shape({
    file: _propTypes2.default.oneOf(statusNames).isRequired,
    ours: _propTypes2.default.oneOf(statusNames).isRequired,
    theirs: _propTypes2.default.oneOf(statusNames).isRequired
  }).isRequired
});

const UserStorePropType = exports.UserStorePropType = _propTypes2.default.shape({
  getUsers: _propTypes2.default.func.isRequired,
  onDidUpdate: _propTypes2.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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