'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when it's uncertain whether or not a git repository is present in a working directory. If
 * it is a git repository, transition to Present, otherwise transition to Empty.
 */
class Loading extends _state2.default {
  async start() {
    const dotGitDir = await this.resolveDotGitDir();
    if (dotGitDir) {
      this.repository.setGitDirectoryPath(dotGitDir);
      const history = await this.loadHistoryPayload();
      return this.transitionTo('Present', history);
    } else {
      return this.transitionTo('Empty');
    }
  }

  isLoading() {
    return true;
  }

  async init() {
    await this.getLoadPromise();
    await this.repository.init();
  }

  async clone(remoteUrl) {
    await this.getLoadPromise();
    await this.repository.clone(remoteUrl);
  }

  showGitTabLoading() {
    return true;
  }

  directResolveDotGitDir() {
    return this.git().resolveDotGitDir();
  }

  directGetConfig(key, options) {
    return this.git().getConfig(key, options);
  }

  directGetBlobContents(sha) {
    return this.git().getBlobContents(sha);
  }
}

exports.default = Loading;
_state2.default.register(Loading);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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