'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain a single project once bootstrapping
 * has completed. Presents in the UI like the Loading state.
 */
class LoadingGuess extends _state2.default {
  isLoadingGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return true;
  }

  showGitTabInit() {
    return false;
  }

  hasDirectory() {
    return false;
  }
}

exports.default = LoadingGuess;
_state2.default.register(LoadingGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmctZ3Vlc3MuanMiXSwibmFtZXMiOlsiTG9hZGluZ0d1ZXNzIiwiU3RhdGUiLCJpc0xvYWRpbmdHdWVzcyIsImlzVW5kZXRlcm1pbmVkIiwic2hvd0dpdFRhYkxvYWRpbmciLCJzaG93R2l0VGFiSW5pdCIsImhhc0RpcmVjdG9yeSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTs7Ozs7O0FBRUE7Ozs7QUFJZSxNQUFNQSxZQUFOLFNBQTJCQyxlQUEzQixDQUFpQztBQUM5Q0MsbUJBQWlCO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sS0FBUDtBQUNEOztBQUVEQyxpQkFBZTtBQUNiLFdBQU8sS0FBUDtBQUNEO0FBbkI2Qzs7a0JBQTNCTixZO0FBc0JyQkMsZ0JBQU1NLFFBQU4sQ0FBZVAsWUFBZiIsImZpbGUiOiJsb2FkaW5nLWd1ZXNzLmpzIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzQuMC9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIvbGliL21vZGVscy9yZXBvc2l0b3J5LXN0YXRlcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBJbml0aWFsIHN0YXRlIHRvIGJlIHVzZWQgd2hlbiB3ZSBhbnRpY2lwYXRlIHRoYXQgdGhlIHdvcmtzcGFjZSB3aWxsIGNvbnRhaW4gYSBzaW5nbGUgcHJvamVjdCBvbmNlIGJvb3RzdHJhcHBpbmdcbiAqIGhhcyBjb21wbGV0ZWQuIFByZXNlbnRzIGluIHRoZSBVSSBsaWtlIHRoZSBMb2FkaW5nIHN0YXRlLlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBMb2FkaW5nR3Vlc3MgZXh0ZW5kcyBTdGF0ZSB7XG4gIGlzTG9hZGluZ0d1ZXNzKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgaXNVbmRldGVybWluZWQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBzaG93R2l0VGFiTG9hZGluZygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIHNob3dHaXRUYWJJbml0KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxuXG4gIGhhc0RpcmVjdG9yeSgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoTG9hZGluZ0d1ZXNzKTtcbiJdfQ==