'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * The working directory exists, but contains no git repository yet.
 */
class Empty extends _state2.default {
  isEmpty() {
    return true;
  }

  init() {
    return this.transitionTo('Initializing');
  }

  clone(remoteUrl) {
    return this.transitionTo('Cloning', remoteUrl);
  }

  showGitTabInit() {
    return true;
  }
}

exports.default = Empty;
_state2.default.register(Empty);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImVtcHR5LmpzIl0sIm5hbWVzIjpbIkVtcHR5IiwiU3RhdGUiLCJpc0VtcHR5IiwiaW5pdCIsInRyYW5zaXRpb25UbyIsImNsb25lIiwicmVtb3RlVXJsIiwic2hvd0dpdFRhYkluaXQiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7Ozs7OztBQUVBOzs7QUFHZSxNQUFNQSxLQUFOLFNBQW9CQyxlQUFwQixDQUEwQjtBQUN2Q0MsWUFBVTtBQUNSLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxTQUFPO0FBQ0wsV0FBTyxLQUFLQyxZQUFMLENBQWtCLGNBQWxCLENBQVA7QUFDRDs7QUFFREMsUUFBTUMsU0FBTixFQUFpQjtBQUNmLFdBQU8sS0FBS0YsWUFBTCxDQUFrQixTQUFsQixFQUE2QkUsU0FBN0IsQ0FBUDtBQUNEOztBQUVEQyxtQkFBaUI7QUFDZixXQUFPLElBQVA7QUFDRDtBQWZzQzs7a0JBQXBCUCxLO0FBa0JyQkMsZ0JBQU1PLFFBQU4sQ0FBZVIsS0FBZiIsImZpbGUiOiJlbXB0eS5qcyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM0LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViL2xpYi9tb2RlbHMvcmVwb3NpdG9yeS1zdGF0ZXMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgU3RhdGUgZnJvbSAnLi9zdGF0ZSc7XG5cbi8qKlxuICogVGhlIHdvcmtpbmcgZGlyZWN0b3J5IGV4aXN0cywgYnV0IGNvbnRhaW5zIG5vIGdpdCByZXBvc2l0b3J5IHlldC5cbiAqL1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgRW1wdHkgZXh0ZW5kcyBTdGF0ZSB7XG4gIGlzRW1wdHkoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBpbml0KCkge1xuICAgIHJldHVybiB0aGlzLnRyYW5zaXRpb25UbygnSW5pdGlhbGl6aW5nJyk7XG4gIH1cblxuICBjbG9uZShyZW1vdGVVcmwpIHtcbiAgICByZXR1cm4gdGhpcy50cmFuc2l0aW9uVG8oJ0Nsb25pbmcnLCByZW1vdGVVcmwpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cbn1cblxuU3RhdGUucmVnaXN0ZXIoRW1wdHkpO1xuIl19