'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
class Cloning extends _state2.default {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  async start() {
    await _fsExtra2.default.mkdirs(this.workdir());
    await this.doClone(this.remoteUrl, { recursive: true });

    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }
}

exports.default = Cloning;
_state2.default.register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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