'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain zero or many projects once bootstrapping
 * has completed. Presents in the UI like the Absent state, but is "sticky" during the initial package activation.
 */
class AbsentGuess extends _state2.default {
  isAbsentGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return false;
  }

  showGitTabInit() {
    return true;
  }

  hasDirectory() {
    return false;
  }
}

exports.default = AbsentGuess;
_state2.default.register(AbsentGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFic2VudC1ndWVzcy5qcyJdLCJuYW1lcyI6WyJBYnNlbnRHdWVzcyIsIlN0YXRlIiwiaXNBYnNlbnRHdWVzcyIsImlzVW5kZXRlcm1pbmVkIiwic2hvd0dpdFRhYkxvYWRpbmciLCJzaG93R2l0VGFiSW5pdCIsImhhc0RpcmVjdG9yeSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTs7Ozs7O0FBRUE7Ozs7QUFJZSxNQUFNQSxXQUFOLFNBQTBCQyxlQUExQixDQUFnQztBQUM3Q0Msa0JBQWdCO0FBQ2QsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxzQkFBb0I7QUFDbEIsV0FBTyxLQUFQO0FBQ0Q7O0FBRURDLG1CQUFpQjtBQUNmLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxpQkFBZTtBQUNiLFdBQU8sS0FBUDtBQUNEO0FBbkI0Qzs7a0JBQTFCTixXO0FBc0JyQkMsZ0JBQU1NLFFBQU4sQ0FBZVAsV0FBZiIsImZpbGUiOiJhYnNlbnQtZ3Vlc3MuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvbW9kZWxzL3JlcG9zaXRvcnktc3RhdGVzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEluaXRpYWwgc3RhdGUgdG8gYmUgdXNlZCB3aGVuIHdlIGFudGljaXBhdGUgdGhhdCB0aGUgd29ya3NwYWNlIHdpbGwgY29udGFpbiB6ZXJvIG9yIG1hbnkgcHJvamVjdHMgb25jZSBib290c3RyYXBwaW5nXG4gKiBoYXMgY29tcGxldGVkLiBQcmVzZW50cyBpbiB0aGUgVUkgbGlrZSB0aGUgQWJzZW50IHN0YXRlLCBidXQgaXMgXCJzdGlja3lcIiBkdXJpbmcgdGhlIGluaXRpYWwgcGFja2FnZSBhY3RpdmF0aW9uLlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBBYnNlbnRHdWVzcyBleHRlbmRzIFN0YXRlIHtcbiAgaXNBYnNlbnRHdWVzcygpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIGlzVW5kZXRlcm1pbmVkKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgc2hvd0dpdFRhYkxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBoYXNEaXJlY3RvcnkoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKEFic2VudEd1ZXNzKTtcbiJdfQ==