'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
class File {

  constructor({ path, mode, symlink }) {
    this.path = path;
    this.mode = mode;
    this.symlink = symlink;
  }

  getPath() {
    return this.path;
  }

  getMode() {
    return this.mode;
  }

  getSymlink() {
    return this.symlink;
  }

  isSymlink() {
    return this.getMode() === this.constructor.modes.SYMLINK;
  }

  isRegularFile() {
    return this.getMode() === this.constructor.modes.NORMAL || this.getMode() === this.constructor.modes.EXECUTABLE;
  }

  isExecutable() {
    return this.getMode() === this.constructor.modes.EXECUTABLE;
  }

  isPresent() {
    return true;
  }

  clone(opts = {}) {
    return new File({
      path: opts.path !== undefined ? opts.path : this.path,
      mode: opts.mode !== undefined ? opts.mode : this.mode,
      symlink: opts.symlink !== undefined ? opts.symlink : this.symlink
    });
  }
}

exports.default = File;
File.modes = {
  // Non-executable, non-symlink
  NORMAL: '100644',

  // +x bit set
  EXECUTABLE: '100755',

  // Soft link to another filesystem location
  SYMLINK: '120000',

  // Submodule mount point
  GITLINK: '160000'
};
const nullFile = exports.nullFile = {
  getPath() {
    /* istanbul ignore next */
    return null;
  },

  getMode() {
    /* istanbul ignore next */
    return null;
  },

  getSymlink() {
    /* istanbul ignore next */
    return null;
  },

  isSymlink() {
    return false;
  },

  isRegularFile() {
    return false;
  },

  isExecutable() {
    return false;
  },

  isPresent() {
    return false;
  },

  clone(opts = {}) {
    if (opts.path === undefined && opts.mode === undefined && opts.symlink === undefined) {
      return this;
    } else {
      return new File({
        path: opts.path !== undefined ? opts.path : this.getPath(),
        mode: opts.mode !== undefined ? opts.mode : this.getMode(),
        symlink: opts.symlink !== undefined ? opts.symlink : this.getSymlink()
      });
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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