"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
class OperationStates {
  constructor(options = {}) {
    this.didUpdate = options.didUpdate || (() => {});
    this.pushInProgress = false;
    this.pullInProgress = false;
    this.fetchInProgress = false;
    this.commitInProgress = false;
    this.checkoutInProgress = false;
  }

  isPushInProgress() {
    return this.pushInProgress;
  }

  isPullInProgress() {
    return this.pullInProgress;
  }

  isFetchInProgress() {
    return this.fetchInProgress;
  }

  isCommitInProgress() {
    return this.commitInProgress;
  }

  isCheckoutInProgress() {
    return this.checkoutInProgress;
  }

  setPushInProgress(value) {
    const oldValue = this.pushInProgress;
    this.pushInProgress = value;
    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setPullInProgress(value) {
    const oldValue = this.pullInProgress;
    this.pullInProgress = value;
    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setFetchInProgress(value) {
    const oldValue = this.fetchInProgress;
    this.fetchInProgress = value;
    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCommitInProgress(value) {
    const oldValue = this.commitInProgress;
    this.commitInProgress = value;
    if (oldValue !== value) {
      this.didUpdate();
    }
  }

  setCheckoutInProgress(value) {
    const oldValue = this.checkoutInProgress;
    this.checkoutInProgress = value;
    if (oldValue !== value) {
      this.didUpdate();
    }
  }
}

exports.default = OperationStates;
class NullOperationStates extends OperationStates {
  setPushInProgress() {
    // do nothing
  }

  setPullInProgress() {
    // do nothing
  }

  setFetchInProgress() {
    // do nothing
  }

  setCommitInProgress() {
    // do nothing
  }

  setCheckoutInProgress() {
    // do nothing
  }
}

const nullOperationStates = exports.nullOperationStates = new NullOperationStates();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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