'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _markerTools = require('./marker-tools');

class Separator {
  constructor(editor, marker) {
    this.editor = editor;
    this.marker = marker;
  }

  getMarker() {
    return this.marker;
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

  isModified() {
    const currentText = this.editor.getTextInBufferRange(this.getMarker().getBufferRange());
    return !/^=======\r?\n?$/.test(currentText);
  }
}
exports.default = Separator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlcGFyYXRvci5qcyJdLCJuYW1lcyI6WyJTZXBhcmF0b3IiLCJjb25zdHJ1Y3RvciIsImVkaXRvciIsIm1hcmtlciIsImdldE1hcmtlciIsImRlbGV0ZSIsImlzTW9kaWZpZWQiLCJjdXJyZW50VGV4dCIsImdldFRleHRJbkJ1ZmZlclJhbmdlIiwiZ2V0QnVmZmVyUmFuZ2UiLCJ0ZXN0Il0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTs7QUFFZSxNQUFNQSxTQUFOLENBQWdCO0FBQzdCQyxjQUFZQyxNQUFaLEVBQW9CQyxNQUFwQixFQUE0QjtBQUMxQixTQUFLRCxNQUFMLEdBQWNBLE1BQWQ7QUFDQSxTQUFLQyxNQUFMLEdBQWNBLE1BQWQ7QUFDRDs7QUFFREMsY0FBWTtBQUNWLFdBQU8sS0FBS0QsTUFBWjtBQUNEOztBQUVERSxXQUFTO0FBQ1AscUNBQWUsS0FBS0QsU0FBTCxFQUFmLEVBQWlDLEtBQUtGLE1BQXRDO0FBQ0Q7O0FBRURJLGVBQWE7QUFDWCxVQUFNQyxjQUFjLEtBQUtMLE1BQUwsQ0FBWU0sb0JBQVosQ0FBaUMsS0FBS0osU0FBTCxHQUFpQkssY0FBakIsRUFBakMsQ0FBcEI7QUFDQSxXQUFPLENBQUMsa0JBQWtCQyxJQUFsQixDQUF1QkgsV0FBdkIsQ0FBUjtBQUNEO0FBakI0QjtrQkFBVlAsUyIsImZpbGUiOiJzZXBhcmF0b3IuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvbW9kZWxzL2NvbmZsaWN0cyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7ZGVsZXRlTWFya2VySW59IGZyb20gJy4vbWFya2VyLXRvb2xzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU2VwYXJhdG9yIHtcbiAgY29uc3RydWN0b3IoZWRpdG9yLCBtYXJrZXIpIHtcbiAgICB0aGlzLmVkaXRvciA9IGVkaXRvcjtcbiAgICB0aGlzLm1hcmtlciA9IG1hcmtlcjtcbiAgfVxuXG4gIGdldE1hcmtlcigpIHtcbiAgICByZXR1cm4gdGhpcy5tYXJrZXI7XG4gIH1cblxuICBkZWxldGUoKSB7XG4gICAgZGVsZXRlTWFya2VySW4odGhpcy5nZXRNYXJrZXIoKSwgdGhpcy5lZGl0b3IpO1xuICB9XG5cbiAgaXNNb2RpZmllZCgpIHtcbiAgICBjb25zdCBjdXJyZW50VGV4dCA9IHRoaXMuZWRpdG9yLmdldFRleHRJbkJ1ZmZlclJhbmdlKHRoaXMuZ2V0TWFya2VyKCkuZ2V0QnVmZmVyUmFuZ2UoKSk7XG4gICAgcmV0dXJuICEvXj09PT09PT1cXHI/XFxuPyQvLnRlc3QoY3VycmVudFRleHQpO1xuICB9XG59XG4iXX0=