'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const UNBORN = Symbol('unborn');

class Commit {
  static createUnborn() {
    return new Commit({ unbornRef: UNBORN });
  }

  constructor({ sha, authorEmail, coAuthors, authorDate, messageSubject, messageBody, unbornRef }) {
    this.sha = sha;
    this.authorEmail = authorEmail;
    this.coAuthors = coAuthors || [];
    this.authorDate = authorDate;
    this.messageSubject = messageSubject;
    this.messageBody = messageBody;
    this.unbornRef = unbornRef === UNBORN;
  }

  getSha() {
    return this.sha;
  }

  getAuthorEmail() {
    return this.authorEmail;
  }

  getAuthorDate() {
    return this.authorDate;
  }

  getCoAuthors() {
    return this.coAuthors;
  }

  getMessageSubject() {
    return this.messageSubject;
  }

  getMessageBody() {
    return this.messageBody;
  }

  getFullMessage() {
    return `${this.getMessageSubject()}\n\n${this.getMessageBody()}`.trim();
  }

  isUnbornRef() {
    return this.unbornRef;
  }

  isPresent() {
    return true;
  }
}

exports.default = Commit;
const nullCommit = exports.nullCommit = {
  getSha() {
    return '';
  },

  getMessageSubject() {
    return '';
  },

  isUnbornRef() {
    return false;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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