'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _reactRelay = require('react-relay');

var _issueishTooltipContainer = require('../containers/issueish-tooltip-container');

var _issueishTooltipContainer2 = _interopRequireDefault(_issueishTooltipContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishTooltipItem {
  constructor(issueishUrl, relayEnvironment) {
    this.issueishUrl = issueishUrl;
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_reactRelay.QueryRenderer, {
        environment: this.relayEnvironment,
        query: _graphql || (_graphql = function () {
          const node = require('./__generated__/issueishTooltipItemQuery.graphql');

          if (node.hash && node.hash !== '8e6b32b5cdcdd3debccc7adaa2b4e82c') {
            console.error('The definition of \'issueishTooltipItemQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
          }

          return require('./__generated__/issueishTooltipItemQuery.graphql');
        }),
        variables: {
          issueishUrl: this.issueishUrl
        },
        render: ({ error, props, retry }) => {
          if (error) {
            return _react2.default.createElement(
              'div',
              null,
              'Could not load information'
            );
          } else if (props) {
            return _react2.default.createElement(_issueishTooltipContainer2.default, props);
          } else {
            return _react2.default.createElement(
              'div',
              { className: 'github-Loader' },
              _react2.default.createElement('span', { className: 'github-Spinner' })
            );
          }
        }
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
}
exports.default = IssueishTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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