'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _gitTabContainer = require('../containers/git-tab-container');

var _gitTabContainer2 = _interopRequireDefault(_gitTabContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabItem extends _react2.default.Component {

  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);

    this.refController = new _refHolder2.default();
  }

  render() {
    return _react2.default.createElement(_gitTabContainer2.default, _extends({
      controllerRef: this.refController
    }, this.props));
  }

  serialize() {
    return {
      deserializer: 'GitDockItem',
      uri: this.getURI()
    };
  }

  getTitle() {
    return 'Git';
  }

  getIconName() {
    return 'git-commit';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return this.constructor.uriPattern;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  // Forwarded to the controller instance when one is present

  rememberLastFocus(...args) {
    return this.refController.map(c => c.rememberLastFocus(...args));
  }

  restoreFocus(...args) {
    return this.refController.map(c => c.restoreFocus(...args));
  }

  hasFocus(...args) {
    return this.refController.map(c => c.hasFocus(...args));
  }

  focus() {
    return this.refController.map(c => c.restoreFocus());
  }

  focusAndSelectStagingItem(...args) {
    return this.refController.map(c => c.focusAndSelectStagingItem(...args));
  }

  focusAndSelectCommitPreviewButton() {
    return this.refController.map(c => c.focusAndSelectCommitPreviewButton());
  }

  quietlySelectItem(...args) {
    return this.refController.map(c => c.quietlySelectItem(...args));
  }
}
exports.default = GitTabItem;
GitTabItem.propTypes = {
  repository: _propTypes2.default.object.isRequired
};
GitTabItem.uriPattern = 'atom-github://dock-item/git';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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