'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _changedFileContainer = require('../containers/changed-file-container');

var _changedFileContainer2 = _interopRequireDefault(_changedFileContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ChangedFileItem extends _react2.default.Component {

  static buildURI(relPath, workingDirectory, stagingStatus) {
    return 'atom-github://file-patch/' + encodeURIComponent(relPath) + `?workdir=${encodeURIComponent(workingDirectory)}` + `&stagingStatus=${encodeURIComponent(stagingStatus)}`;
  }

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'destroy');

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
  }

  getTitle() {
    let title = this.props.stagingStatus === 'staged' ? 'Staged' : 'Unstaged';
    title += ' Changes: ';
    title += this.props.relPath;
    return title;
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  destroy() {
    /* istanbul ignore else */
    if (!this.isDestroyed) {
      this.emitter.emit('did-destroy');
      this.isDestroyed = true;
    }
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();

    return _react2.default.createElement(_changedFileContainer2.default, _extends({
      itemType: this.constructor,
      repository: repository,
      destroy: this.destroy
    }, this.props));
  }

  serialize() {
    return {
      deserializer: 'FilePatchControllerStub',
      uri: ChangedFileItem.buildURI(this.props.relPath, this.props.workingDirectory, this.props.stagingStatus)
    };
  }

  getStagingStatus() {
    return this.props.stagingStatus;
  }

  getFilePath() {
    return this.props.relPath;
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  isFilePatchItem() {
    return true;
  }
}
exports.default = ChangedFileItem;
ChangedFileItem.propTypes = {
  workdirContextPool: _propTypes3.WorkdirContextPoolPropType.isRequired,

  relPath: _propTypes2.default.string.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['staged', 'unstaged']),

  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  discardLines: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  surfaceFileAtPath: _propTypes2.default.func.isRequired
};
ChangedFileItem.uriPattern = 'atom-github://file-patch/{relPath...}?workdir={workingDirectory}&stagingStatus={stagingStatus}';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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