'use strict';

var _githubPackage = require('./github-package');

var _githubPackage2 = _interopRequireDefault(_githubPackage);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage2.default({
      workspace: atom.workspace,
      project: atom.project,
      commandRegistry: atom.commands,
      notificationManager: atom.notifications,
      tooltips: atom.tooltips,
      styles: atom.styles,
      keymaps: atom.keymaps,
      grammars: atom.grammars,
      config: atom.config,
      deserializers: atom.deserializers,

      confirm: atom.confirm.bind(atom),
      getLoadSettings: atom.getLoadSettings.bind(atom),

      configDirPath: atom.getConfigDirPath()
    });
  }
};

module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];
      if (typeof item === 'function') {
        item = item.bind(pack);
      }
      return item;
    } else {
      return target[name];
    }
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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