'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BIN_SCRIPTS = undefined;

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

var _helpers = require('./helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const BIN_SCRIPTS = exports.BIN_SCRIPTS = {
  getCredentialHelperJs: 'git-credential-atom.js',
  getCredentialHelperSh: 'git-credential-atom.sh',
  getAskPassJs: 'git-askpass-atom.js',
  getAskPassSh: 'git-askpass-atom.sh',
  getSshWrapperSh: 'linux-ssh-wrapper.sh',
  getGpgWrapperSh: 'gpg-wrapper.sh'
};

class GitTempDir {
  constructor() {
    this.created = false;
  }

  async ensure() {
    if (this.created) {
      return;
    }

    this.root = await (0, _helpers.getTempDir)({
      dir: process.platform === 'win32' ? _os2.default.tmpdir() : '/tmp',
      prefix: 'github-',
      symlinkOk: true
    });

    await Promise.all(Object.values(BIN_SCRIPTS).map(async filename => {
      await _fsExtra2.default.copy(_path2.default.resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path2.default.join(this.root, filename));

      if (_path2.default.extname(filename) === '.sh') {
        await _fsExtra2.default.chmod(_path2.default.join(this.root, filename), 0o700);
      }
    }));

    this.created = true;
  }

  getRootPath() {
    return this.root;
  }

  getScriptPath(filename) {
    if (!this.created) {
      throw new Error(`Attempt to access filename ${filename} in uninitialized GitTempDir`);
    }

    return _path2.default.join(this.root, filename);
  }

  getSocketPath() {
    if (process.platform === 'win32') {
      if (!this.socketPath) {
        this.socketPath = _path2.default.join('\\\\?\\pipe\\', 'gh-' + require('crypto').randomBytes(8).toString('hex'), 'helper.sock');
      }
      return this.socketPath;
    } else {
      return this.getScriptPath('helper.sock');
    }
  }

  dispose() {
    return _fsExtra2.default.remove(this.root);
  }
}

exports.default = GitTempDir;
function createGetter(key) {
  const filename = BIN_SCRIPTS[key];
  return function () {
    return this.getScriptPath(filename);
  };
}

for (const key in BIN_SCRIPTS) {
  GitTempDir.prototype[key] = createGetter(key);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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