'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _branchView = require('../views/branch-view');

var _branchView2 = _interopRequireDefault(_branchView);

var _branchMenuView = require('../views/branch-menu-view');

var _branchMenuView2 = _interopRequireDefault(_branchMenuView);

var _pushPullView = require('../views/push-pull-view');

var _pushPullView2 = _interopRequireDefault(_pushPullView);

var _changedFilesCountView = require('../views/changed-files-count-view');

var _changedFilesCountView2 = _interopRequireDefault(_changedFilesCountView);

var _githubTileView = require('../views/github-tile-view');

var _githubTileView2 = _interopRequireDefault(_githubTileView);

var _tooltip = require('../atom/tooltip');

var _tooltip2 = _interopRequireDefault(_tooltip);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class StatusBarTileController extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.fetchData = repository => {
      return (0, _yubikiri2.default)({
        currentBranch: repository.getCurrentBranch(),
        branches: repository.getBranches(),
        statusesForChangedFiles: repository.getStatusesForChangedFiles(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        aheadCount: async query => repository.getAheadCount((await query.currentBranch).getName()),
        behindCount: async query => repository.getBehindCount((await query.currentBranch).getName()),
        originExists: async () => (await repository.getRemotes()).withName('origin').isPresent()
      });
    };

    this.handleOpenGitTimingsView = e => {
      e && e.preventDefault();
      this.props.workspace.open('atom-github://debug/timings');
    };

    this.checkout = (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    };

    this.refBranchViewRoot = new _refHolder2.default();
  }

  getChangedFilesCount(data) {
    const { stagedFiles, unstagedFiles, mergeConflictFiles } = data.statusesForChangedFiles;
    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }
    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      data => data ? this.renderWithData(data) : null
    );
  }

  renderWithData(data) {
    let changedFilesCount, mergeConflictsPresent;
    if (data.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount(data);
      mergeConflictsPresent = Object.keys(data.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    if (mergeConflictsPresent) {
      this.props.ensureGitTabVisible();
    }
    const repoProps = {
      repository: this.props.repository,
      currentBranch: data.currentBranch,
      branches: data.branches,
      currentRemote: data.currentRemote,
      aheadCount: data.aheadCount,
      behindCount: data.behindCount,
      originExists: data.originExists,
      changedFilesCount,
      mergeConflictsPresent
    };

    return _react2.default.createElement(
      _react.Fragment,
      null,
      this.renderTiles(repoProps),
      _react2.default.createElement(_githubTileView2.default, { didClick: this.props.toggleGithubTab }),
      _react2.default.createElement(_changedFilesCountView2.default, {
        didClick: this.props.toggleGitTab,
        changedFilesCount: repoProps.changedFilesCount,
        mergeConflictsPresent: repoProps.mergeConflictsPresent
      })
    );
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    const operationStates = this.props.repository.getOperationStates();
    const pushInProgress = operationStates.isPushInProgress();
    const pullInProgress = operationStates.isPullInProgress();
    const fetchInProgress = operationStates.isFetchInProgress();

    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: 'atom-workspace' },
        _react2.default.createElement(_commands.Command, { command: 'github:fetch', callback: this.fetch(repoProps) }),
        _react2.default.createElement(_commands.Command, { command: 'github:pull', callback: this.pull(repoProps) }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:push',
          callback: () => this.push(repoProps)({ force: false, setUpstream: !repoProps.currentRemote.isPresent() })
        }),
        _react2.default.createElement(_commands.Command, {
          command: 'github:force-push',
          callback: () => this.push(repoProps)({ force: true, setUpstream: !repoProps.currentRemote.isPresent() })
        })
      ),
      _react2.default.createElement(_branchView2.default, {
        refRoot: this.refBranchViewRoot.setter,
        workspace: this.props.workspace,
        checkout: this.checkout,
        currentBranch: repoProps.currentBranch
      }),
      _react2.default.createElement(
        _tooltip2.default,
        {
          manager: this.props.tooltips,
          target: this.refBranchViewRoot,
          trigger: 'click',
          className: 'github-StatusBarTileController-tooltipMenu' },
        _react2.default.createElement(_branchMenuView2.default, {
          workspace: this.props.workspace,
          notificationManager: this.props.notificationManager,
          commandRegistry: this.props.commandRegistry,
          checkout: this.checkout,
          branches: repoProps.branches,
          currentBranch: repoProps.currentBranch
        })
      ),
      _react2.default.createElement(_pushPullView2.default, {
        isSyncing: fetchInProgress || pullInProgress || pushInProgress,
        isFetching: fetchInProgress,
        isPulling: pullInProgress,
        isPushing: pushInProgress,
        push: this.push(repoProps),
        pull: this.pull(repoProps),
        fetch: this.fetch(repoProps),
        tooltipManager: this.props.tooltips,
        currentBranch: repoProps.currentBranch,
        currentRemote: repoProps.currentRemote,
        behindCount: repoProps.behindCount,
        aheadCount: repoProps.aheadCount,
        originExists: repoProps.originExists
      })
    );
  }

  push(data) {
    return ({ force, setUpstream } = {}) => {
      return this.props.repository.push(data.currentBranch.getName(), {
        force,
        setUpstream,
        refSpec: data.currentBranch.getRefSpec('PUSH')
      });
    };
  }

  pull(data) {
    return () => {
      return this.props.repository.pull(data.currentBranch.getName(), {
        refSpec: data.currentBranch.getRefSpec('PULL')
      });
    };
  }

  fetch(data) {
    return () => {
      const upstream = data.currentBranch.getUpstream();
      return this.props.repository.fetch(upstream.getRemoteRef(), {
        remoteName: upstream.getRemoteName()
      });
    };
  }
}
exports.default = StatusBarTileController;
StatusBarTileController.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  confirm: _propTypes2.default.func.isRequired,
  repository: _propTypes2.default.object.isRequired,
  toggleGitTab: _propTypes2.default.func,
  toggleGithubTab: _propTypes2.default.func,
  ensureGitTabVisible: _propTypes2.default.func
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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