'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _eventKit = require('event-kit');

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _resolutionProgress = require('../models/conflicts/resolution-progress');

var _resolutionProgress2 = _interopRequireDefault(_resolutionProgress);

var _editorConflictController = require('./editor-conflict-controller');

var _editorConflictController2 = _interopRequireDefault(_editorConflictController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DEFAULT_REPO_DATA = {
  mergeConflictPaths: [],
  isRebasing: false
};

/**
 * Render an `EditorConflictController` for each `TextEditor` open on a file that contains git conflict markers.
 */
class RepositoryConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.fetchData = repository => {
      return (0, _yubikiri2.default)({
        workingDirectoryPath: repository.getWorkingDirectoryPath(),
        mergeConflictPaths: repository.getMergeConflicts().then(conflicts => {
          return conflicts.map(conflict => conflict.filePath);
        }),
        isRebasing: repository.isRebasing()
      });
    };

    this.state = { openEditors: this.props.workspace.getTextEditors() };
    this.subscriptions = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    const updateState = () => {
      this.setState({
        openEditors: this.props.workspace.getTextEditors()
      });
    };

    this.subscriptions.add(this.props.workspace.observeTextEditors(updateState), this.props.workspace.onDidDestroyPaneItem(updateState), this.props.config.observe('github.graphicalConflictResolution', () => this.forceUpdate()));
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      data => this.renderWithData(data || DEFAULT_REPO_DATA)
    );
  }

  renderWithData(repoData) {
    const conflictingEditors = this.getConflictingEditors(repoData);

    return _react2.default.createElement(
      'div',
      null,
      conflictingEditors.map(editor => _react2.default.createElement(_editorConflictController2.default, {
        key: editor.id,
        commandRegistry: this.props.commandRegistry,
        resolutionProgress: this.props.resolutionProgress,
        editor: editor,
        isRebase: repoData.isRebasing,
        refreshResolutionProgress: this.props.refreshResolutionProgress
      }))
    );
  }

  getConflictingEditors(repoData) {
    if (repoData.mergeConflictPaths.length === 0 || this.state.openEditors.length === 0 || !this.props.config.get('github.graphicalConflictResolution')) {
      return [];
    }

    const commonBasePath = this.props.repository.getWorkingDirectoryPath();
    const fullMergeConflictPaths = new Set(repoData.mergeConflictPaths.map(relativePath => _path2.default.join(commonBasePath, relativePath)));

    return this.state.openEditors.filter(editor => fullMergeConflictPaths.has(editor.getPath()));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }
}
exports.default = RepositoryConflictController;
RepositoryConflictController.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object.isRequired,
  refreshResolutionProgress: _propTypes2.default.func
};
RepositoryConflictController.defaultProps = {
  refreshResolutionProgress: () => {},
  resolutionProgress: new _resolutionProgress2.default()
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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