'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _helpers = require('../helpers');

var _reporterProxy = require('../reporter-proxy');

var _propTypes3 = require('../prop-types');

var _issueishSearchesController = require('./issueish-searches-controller');

var _issueishSearchesController2 = _interopRequireDefault(_issueishSearchesController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RemoteController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onCreatePr');
  }

  render() {
    return _react2.default.createElement(_issueishSearchesController2.default, {
      host: this.props.host,
      token: this.props.token,

      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,

      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,

      onCreatePr: this.onCreatePr
    });
  }

  async onCreatePr() {
    const currentBranch = this.props.branches.getHeadBranch();
    const upstream = currentBranch.getUpstream();
    if (!upstream.isPresent() || this.props.aheadCount > 0) {
      await this.props.onPushBranch();
    }

    let createPrUrl = 'https://github.com/';
    createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
    createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
    createPrUrl += '?expand=1';

    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(createPrUrl, {}, err => {
        if (err) {
          reject(err);
        } else {
          (0, _reporterProxy.incrementCounter)('create-pull-request');
          resolve();
        }
      });
    });
  }
}
exports.default = RemoteController;
RemoteController.propTypes = {
  host: _propTypes2.default.string.isRequired,
  token: _propTypes2.default.string.isRequired,

  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  workspace: _propTypes2.default.object.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,

  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onPushBranch: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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