'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _helpers = require('../helpers');

var _reporterProxy = require('../reporter-proxy');

var _propTypes3 = require('../prop-types');

var _changedFileItem = require('../items/changed-file-item');

var _changedFileItem2 = _interopRequireDefault(_changedFileItem);

var _multiFilePatchView = require('../views/multi-file-patch-view');

var _multiFilePatchView2 = _interopRequireDefault(_multiFilePatchView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class MultiFilePatchController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'selectedRowsChanged', 'undoLastDiscard', 'diveIntoMirrorPatch', 'openFile', 'toggleFile', 'toggleRows', 'toggleModeChange', 'toggleSymlinkChange', 'discardRows');

    this.state = {
      selectionMode: 'hunk',
      selectedRows: new Set(),
      hasMultipleFileSelections: false
    };

    this.mouseSelectionInProgress = false;
    this.stagingOperationInProgress = false;

    this.lastPatchString = null;
    this.patchChangePromise = new Promise(resolve => {
      this.resolvePatchChangePromise = resolve;
    });
  }

  componentDidUpdate(prevProps) {
    if (this.lastPatchString !== null && this.lastPatchString !== this.props.multiFilePatch.toString()) {
      this.resolvePatchChangePromise();
      this.patchChangePromise = new Promise(resolve => {
        this.resolvePatchChangePromise = resolve;
      });
    }
  }

  render() {
    return _react2.default.createElement(_multiFilePatchView2.default, _extends({}, this.props, {

      selectedRows: this.state.selectedRows,
      selectionMode: this.state.selectionMode,
      hasMultipleFileSelections: this.state.hasMultipleFileSelections,
      selectedRowsChanged: this.selectedRowsChanged,

      diveIntoMirrorPatch: this.diveIntoMirrorPatch,
      openFile: this.openFile,
      toggleFile: this.toggleFile,
      toggleRows: this.toggleRows,
      toggleModeChange: this.toggleModeChange,
      toggleSymlinkChange: this.toggleSymlinkChange,
      undoLastDiscard: this.undoLastDiscard,
      discardRows: this.discardRows,
      selectNextHunk: this.selectNextHunk,
      selectPreviousHunk: this.selectPreviousHunk
    }));
  }

  undoLastDiscard(filePatch, { eventSource } = {}) {
    (0, _reporterProxy.addEvent)('undo-last-discard', {
      package: 'github',
      component: this.constructor.name,
      eventSource
    });

    return this.props.undoLastDiscard(filePatch.getPath(), this.props.repository);
  }

  diveIntoMirrorPatch(filePatch) {
    const mirrorStatus = this.withStagingStatus({ staged: 'unstaged', unstaged: 'staged' });
    const workingDirectory = this.props.repository.getWorkingDirectoryPath();
    const uri = _changedFileItem2.default.buildURI(filePatch.getPath(), workingDirectory, mirrorStatus);

    this.props.destroy();
    return this.props.workspace.open(uri);
  }

  async openFile(filePatch, positions, pending) {
    const absolutePath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), filePatch.getPath());
    const editor = await this.props.workspace.open(absolutePath, { pending });
    if (positions.length > 0) {
      editor.setCursorBufferPosition(positions[0], { autoscroll: false });
      for (const position of positions.slice(1)) {
        editor.addCursorAtBufferPosition(position);
      }
      editor.scrollToBufferPosition(positions[positions.length - 1], { center: true });
    }
    return editor;
  }

  toggleFile(filePatch) {
    return this.stagingOperation(() => {
      const methodName = this.withStagingStatus({ staged: 'unstageFiles', unstaged: 'stageFiles' });
      return this.props.repository[methodName]([filePatch.getPath()]);
    });
  }

  async toggleRows(rowSet, nextSelectionMode) {
    let chosenRows = rowSet;
    if (chosenRows) {
      const nextMultipleFileSelections = this.props.multiFilePatch.spansMultipleFiles(chosenRows);
      await this.selectedRowsChanged(chosenRows, nextSelectionMode, nextMultipleFileSelections);
    } else {
      chosenRows = this.state.selectedRows;
    }

    if (chosenRows.size === 0) {
      return Promise.resolve();
    }

    return this.stagingOperation(() => {
      const patch = this.withStagingStatus({
        staged: () => this.props.multiFilePatch.getUnstagePatchForLines(chosenRows),
        unstaged: () => this.props.multiFilePatch.getStagePatchForLines(chosenRows)
      });
      return this.props.repository.applyPatchToIndex(patch);
    });
  }

  toggleModeChange(filePatch) {
    return this.stagingOperation(() => {
      const targetMode = this.withStagingStatus({
        unstaged: filePatch.getNewMode(),
        staged: filePatch.getOldMode()
      });
      return this.props.repository.stageFileModeChange(filePatch.getPath(), targetMode);
    });
  }

  toggleSymlinkChange(filePatch) {
    return this.stagingOperation(() => {
      const relPath = filePatch.getPath();
      const repository = this.props.repository;
      return this.withStagingStatus({
        unstaged: () => {
          if (filePatch.hasTypechange() && filePatch.getStatus() === 'added') {
            return repository.stageFileSymlinkChange(relPath);
          }

          return repository.stageFiles([relPath]);
        },
        staged: () => {
          if (filePatch.hasTypechange() && filePatch.getStatus() === 'deleted') {
            return repository.stageFileSymlinkChange(relPath);
          }

          return repository.unstageFiles([relPath]);
        }
      });
    });
  }

  async discardRows(rowSet, nextSelectionMode, { eventSource } = {}) {
    // (kuychaco) For now we only support discarding rows for MultiFilePatches that contain a single file patch
    // The only way to access this method from the UI is to be in a ChangedFileItem, which only has a single file patch
    // This check is duplicated in RootController#discardLines. We also want it here to prevent us from sending metrics
    // unnecessarily
    if (this.props.multiFilePatch.getFilePatches().length !== 1) {
      return Promise.resolve(null);
    }

    let chosenRows = rowSet;
    if (chosenRows) {
      const nextMultipleFileSelections = this.props.multiFilePatch.spansMultipleFiles(chosenRows);
      await this.selectedRowsChanged(chosenRows, nextSelectionMode, nextMultipleFileSelections);
    } else {
      chosenRows = this.state.selectedRows;
    }

    (0, _reporterProxy.addEvent)('discard-unstaged-changes', {
      package: 'github',
      component: this.constructor.name,
      lineCount: chosenRows.size,
      eventSource
    });

    return this.props.discardLines(this.props.multiFilePatch, chosenRows, this.props.repository);
  }

  selectedRowsChanged(rows, nextSelectionMode, nextMultipleFileSelections) {
    if ((0, _helpers.equalSets)(this.state.selectedRows, rows) && this.state.selectionMode === nextSelectionMode && this.state.hasMultipleFileSelections === nextMultipleFileSelections) {
      return Promise.resolve();
    }

    return new Promise(resolve => {
      this.setState({
        selectedRows: rows,
        selectionMode: nextSelectionMode,
        hasMultipleFileSelections: nextMultipleFileSelections
      }, resolve);
    });
  }

  withStagingStatus(callbacks) {
    const callback = callbacks[this.props.stagingStatus];
    /* istanbul ignore if */
    if (!callback) {
      throw new Error(`Unknown staging status: ${this.props.stagingStatus}`);
    }
    return callback instanceof Function ? callback() : callback;
  }

  stagingOperation(fn) {
    if (this.stagingOperationInProgress) {
      return null;
    }

    this.stagingOperationInProgress = true;
    this.lastPatchString = this.props.multiFilePatch.toString();
    const operationPromise = fn();

    operationPromise.then(() => this.patchChangePromise).then(() => {
      this.stagingOperationInProgress = false;
      this.lastPatchString = null;
    });

    return operationPromise;
  }
}
exports.default = MultiFilePatchController;
MultiFilePatchController.propTypes = {
  repository: _propTypes2.default.object.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['staged', 'unstaged']),
  multiFilePatch: _propTypes3.MultiFilePatchPropType.isRequired,
  hasUndoHistory: _propTypes2.default.bool,

  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  destroy: _propTypes2.default.func.isRequired,
  discardLines: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  surface: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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