'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _search = require('../models/search');

var _search2 = _interopRequireDefault(_search);

var _issueishSearchContainer = require('../containers/issueish-search-container');

var _issueishSearchContainer2 = _interopRequireDefault(_issueishSearchContainer);

var _currentPullRequestContainer = require('../containers/current-pull-request-container');

var _currentPullRequestContainer2 = _interopRequireDefault(_currentPullRequestContainer);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishSearchesController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onOpenIssueish', 'onOpenSearch');

    this.state = {};
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search2.default.inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishSearch' },
      _react2.default.createElement(_currentPullRequestContainer2.default, {
        repository: this.props.repository,
        token: this.props.token,
        host: this.props.host,
        remoteOperationObserver: this.props.remoteOperationObserver,
        remote: this.props.remote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,
        pushInProgress: this.props.pushInProgress,

        onOpenIssueish: this.onOpenIssueish,
        onCreatePr: this.props.onCreatePr
      }),
      this.state.searches.map(search => _react2.default.createElement(_issueishSearchContainer2.default, {
        key: search.getName(),

        token: this.props.token,
        host: this.props.host,
        search: search,
        remoteOperationObserver: this.props.remoteOperationObserver,

        onOpenIssueish: this.onOpenIssueish,
        onOpenSearch: this.onOpenSearch
      }))
    );
  }

  onOpenIssueish(issueish) {
    return this.props.workspace.open(_issueishDetailItem2.default.buildURI(this.props.host, this.props.remote.getOwner(), this.props.remote.getRepo(), issueish.getNumber(), this.props.workingDirectory), { pending: true, searchAllPanes: true }).then(() => {
      (0, _reporterProxy.addEvent)('open-issueish-in-pane', { package: 'github', from: 'issueish-list' });
    });
  }

  onOpenSearch(search) {
    const searchURL = search.getWebURL(this.props.remote);

    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(searchURL, {}, err => {
        if (err) {
          reject(err);
        } else {
          resolve();
        }
      });
    });
  }
}
exports.default = IssueishSearchesController;
IssueishSearchesController.propTypes = {
  host: _propTypes2.default.string.isRequired,
  token: _propTypes2.default.string.isRequired,
  workspace: _propTypes2.default.object.isRequired,

  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onCreatePr: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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