'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareIssueishListController = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _issueishListView = require('../views/issueish-list-view');

var _issueishListView2 = _interopRequireDefault(_issueishListView);

var _issueish = require('../models/issueish');

var _issueish2 = _interopRequireDefault(_issueish);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const StatePropType = _propTypes2.default.oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish2.default(node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react2.default.createElement(_issueishListView2.default, {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,

      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,

      emptyComponent: this.props.emptyComponent
    });
  }
}

exports.BareIssueishListController = BareIssueishListController;
BareIssueishListController.propTypes = {
  results: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    number: _propTypes2.default.number.isRequired,
    title: _propTypes2.default.string.isRequired,
    url: _propTypes2.default.string.isRequired,
    author: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired,
      avatarUrl: _propTypes2.default.string.isRequired
    }).isRequired,
    createdAt: _propTypes2.default.string.isRequired,
    headRefName: _propTypes2.default.string.isRequired,
    repository: _propTypes2.default.shape({
      id: _propTypes2.default.string.isRequired
    }).isRequired,
    commits: _propTypes2.default.shape({
      nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
        commit: _propTypes2.default.shape({
          status: _propTypes2.default.shape({
            contexts: _propTypes2.default.arrayOf(_propTypes2.default.shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes2.default.number.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  title: _propTypes2.default.string.isRequired,
  error: _propTypes2.default.object,

  resultFilter: _propTypes2.default.func,
  onOpenIssueish: _propTypes2.default.func.isRequired,
  onOpenMore: _propTypes2.default.func,

  emptyComponent: _propTypes2.default.func
};
BareIssueishListController.defaultProps = {
  results: [],
  total: 0,
  resultFilter: () => true
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require('./__generated__/issueishListController_results.graphql');

    if (node.hash && node.hash !== '5de45944d2555aea09c239d314a9fefd') {
      console.error('The definition of \'issueishListController_results\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueishListController_results.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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