'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _githubTabView = require('../views/github-tab-view');

var _githubTabView2 = _interopRequireDefault(_githubTabView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitHubTabController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'handlePushBranch', 'handleRemoteSelect');
  }

  render() {
    const gitHubRemotes = this.props.allRemotes.filter(remote => remote.isGithubRepo());
    const currentBranch = this.props.branches.getHeadBranch();

    let currentRemote = gitHubRemotes.withName(this.props.selectedRemoteName);
    let manyRemotesAvailable = false;
    if (!currentRemote.isPresent() && gitHubRemotes.size() === 1) {
      currentRemote = Array.from(gitHubRemotes)[0];
    } else if (!currentRemote.isPresent() && gitHubRemotes.size() > 1) {
      manyRemotesAvailable = true;
    }

    return _react2.default.createElement(_githubTabView2.default, {
      workspace: this.props.workspace,
      remoteOperationObserver: this.props.remoteOperationObserver,
      loginModel: this.props.loginModel,
      rootHolder: this.props.rootHolder,

      workingDirectory: this.props.workingDirectory,
      branches: this.props.branches,
      currentBranch: currentBranch,
      remotes: gitHubRemotes,
      currentRemote: currentRemote,
      manyRemotesAvailable: manyRemotesAvailable,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      isLoading: this.props.isLoading,

      handlePushBranch: this.handlePushBranch,
      handleRemoteSelect: this.handleRemoteSelect
    });
  }

  handlePushBranch(currentBranch, targetRemote) {
    return this.props.repository.push(currentBranch.getName(), {
      remote: targetRemote,
      setUpstream: true
    });
  }

  handleRemoteSelect(e, remote) {
    e.preventDefault();
    return this.props.repository.setConfig('atomGithub.currentRemote', remote.getName());
  }
}
exports.default = GitHubTabController;
GitHubTabController.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object.isRequired,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes3.RefHolderPropType.isRequired,

  workingDirectory: _propTypes2.default.string.isRequired,
  allRemotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  selectedRemoteName: _propTypes2.default.string,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,
  isLoading: _propTypes2.default.bool.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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