'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _author = require('../models/author');

var _author2 = _interopRequireDefault(_author);

var _gitTabView = require('../views/git-tab-view');

var _gitTabView2 = _interopRequireDefault(_gitTabView);

var _userStore = require('../models/user-store');

var _userStore2 = _interopRequireDefault(_userStore);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'attemptStageAllOperation', 'attemptFileStageOperation', 'unstageFiles', 'prepareToCommit', 'commit', 'updateSelectedCoAuthors', 'undoLastCommit', 'abortMerge', 'resolveAsOurs', 'resolveAsTheirs', 'checkout', 'rememberLastFocus', 'quietlySelectItem');

    this.stagingOperationInProgress = false;
    this.lastFocus = _gitTabView2.default.focus.STAGING;

    this.refView = new _refHolder2.default();
    this.refRoot = new _refHolder2.default();
    this.refStagingView = new _refHolder2.default();

    this.state = {
      selectedCoAuthors: []
    };

    this.userStore = new _userStore2.default({
      repository: this.props.repository,
      login: this.props.loginModel,
      config: this.props.config
    });
  }

  render() {
    return _react2.default.createElement(_gitTabView2.default, {
      ref: this.refView.setter,
      refRoot: this.refRoot,
      refStagingView: this.refStagingView,

      isLoading: this.props.fetchInProgress,
      repository: this.props.repository,

      lastCommit: this.props.lastCommit,
      recentCommits: this.props.recentCommits,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      hasUndoHistory: this.props.hasUndoHistory,
      currentBranch: this.props.currentBranch,
      unstagedChanges: this.props.unstagedChanges,
      stagedChanges: this.props.stagedChanges,
      mergeConflicts: this.props.mergeConflicts,
      workingDirectoryPath: this.props.workingDirectoryPath,
      mergeMessage: this.props.mergeMessage,
      userStore: this.userStore,
      selectedCoAuthors: this.state.selectedCoAuthors,
      updateSelectedCoAuthors: this.updateSelectedCoAuthors,

      resolutionProgress: this.props.resolutionProgress,
      workspace: this.props.workspace,
      commandRegistry: this.props.commandRegistry,
      grammars: this.props.grammars,
      tooltips: this.props.tooltips,
      notificationManager: this.props.notificationManager,
      project: this.props.project,
      confirm: this.props.confirm,
      config: this.props.config,

      initializeRepo: this.props.initializeRepo,
      openFiles: this.props.openFiles,
      discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
      undoLastDiscard: this.props.undoLastDiscard,

      attemptFileStageOperation: this.attemptFileStageOperation,
      attemptStageAllOperation: this.attemptStageAllOperation,
      prepareToCommit: this.prepareToCommit,
      commit: this.commit,
      undoLastCommit: this.undoLastCommit,
      push: this.push,
      pull: this.pull,
      fetch: this.fetch,
      checkout: this.checkout,
      abortMerge: this.abortMerge,
      resolveAsOurs: this.resolveAsOurs,
      resolveAsTheirs: this.resolveAsTheirs
    });
  }

  componentDidMount() {
    this.refreshResolutionProgress(false, false);
    this.refRoot.map(root => root.addEventListener('focusin', this.rememberLastFocus));

    if (this.props.controllerRef) {
      this.props.controllerRef.setter(this);
    }
  }

  componentDidUpdate() {
    this.userStore.setRepository(this.props.repository);
    this.userStore.setLoginModel(this.props.loginModel);
    this.refreshResolutionProgress(false, false);
  }

  componentWillUnmount() {
    this.refRoot.map(root => root.removeEventListener('focusin', this.rememberLastFocus));
  }

  /*
   * Begin (but don't await) an async conflict-counting task for each merge conflict path that has no conflict
   * marker count yet. Omit any path that's already open in a TextEditor or that has already been counted.
   *
   * includeOpen - update marker counts for files that are currently open in TextEditors
   * includeCounted - update marker counts for files that have been counted before
   */
  refreshResolutionProgress(includeOpen, includeCounted) {
    if (this.props.fetchInProgress) {
      return;
    }

    const openPaths = new Set(this.props.workspace.getTextEditors().map(editor => editor.getPath()));

    for (let i = 0; i < this.props.mergeConflicts.length; i++) {
      const conflictPath = _path2.default.join(this.props.workingDirectoryPath, this.props.mergeConflicts[i].filePath);

      if (!includeOpen && openPaths.has(conflictPath)) {
        continue;
      }

      if (!includeCounted && this.props.resolutionProgress.getRemaining(conflictPath) !== undefined) {
        continue;
      }

      this.props.refreshResolutionProgress(conflictPath);
    }
  }

  attemptStageAllOperation(stageStatus) {
    return this.attemptFileStageOperation(['.'], stageStatus);
  }

  attemptFileStageOperation(filePaths, stageStatus) {
    if (this.stagingOperationInProgress) {
      return {
        stageOperationPromise: Promise.resolve(),
        selectionUpdatePromise: Promise.resolve()
      };
    }

    this.stagingOperationInProgress = true;

    const fileListUpdatePromise = this.refStagingView.map(view => {
      return view.getNextListUpdatePromise();
    }).getOr(Promise.resolve());
    let stageOperationPromise;
    if (stageStatus === 'staged') {
      stageOperationPromise = this.unstageFiles(filePaths);
    } else {
      stageOperationPromise = this.stageFiles(filePaths);
    }
    const selectionUpdatePromise = fileListUpdatePromise.then(() => {
      this.stagingOperationInProgress = false;
    });

    return { stageOperationPromise, selectionUpdatePromise };
  }

  async stageFiles(filePaths) {
    const pathsToStage = new Set(filePaths);

    const mergeMarkers = await Promise.all(filePaths.map(async filePath => {
      return {
        filePath,
        hasMarkers: await this.props.repository.pathHasMergeMarkers(filePath)
      };
    }));

    for (const _ref of mergeMarkers) {
      const { filePath, hasMarkers } = _ref;

      if (hasMarkers) {
        const choice = this.props.confirm({
          message: 'File contains merge markers: ',
          detailedMessage: `Do you still want to stage this file?\n${filePath}`,
          buttons: ['Stage', 'Cancel']
        });
        if (choice !== 0) {
          pathsToStage.delete(filePath);
        }
      }
    }

    return this.props.repository.stageFiles(Array.from(pathsToStage));
  }

  unstageFiles(filePaths) {
    return this.props.repository.unstageFiles(filePaths);
  }

  async prepareToCommit() {
    return !(await this.props.ensureGitTab());
  }

  commit(message, options) {
    return this.props.repository.commit(message, options);
  }

  updateSelectedCoAuthors(selectedCoAuthors, newAuthor) {
    if (newAuthor) {
      this.userStore.addUsers([newAuthor]);
      selectedCoAuthors = selectedCoAuthors.concat([newAuthor]);
    }
    this.setState({ selectedCoAuthors });
  }

  async undoLastCommit() {
    const repo = this.props.repository;
    const lastCommit = await repo.getLastCommit();
    if (lastCommit.isUnbornRef()) {
      return null;
    }

    await repo.undoLastCommit();
    repo.setCommitMessage(lastCommit.getFullMessage());

    const coAuthors = lastCommit.getCoAuthors().map(author => new _author2.default(author.email, author.name));

    this.updateSelectedCoAuthors(coAuthors);
    return null;
  }

  async abortMerge() {
    const choice = this.props.confirm({
      message: 'Abort merge',
      detailedMessage: 'Are you sure?',
      buttons: ['Abort', 'Cancel']
    });
    if (choice !== 0) {
      return;
    }

    try {
      await this.props.repository.abortMerge();
    } catch (e) {
      if (e.code === 'EDIRTYSTAGED') {
        this.props.notificationManager.addError(`Cannot abort because ${e.path} is both dirty and staged.`, { dismissable: true });
      } else {
        throw e;
      }
    }
  }

  async resolveAsOurs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'theirs' : 'ours';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  async resolveAsTheirs(paths) {
    if (this.props.fetchInProgress) {
      return;
    }

    const side = this.props.isRebasing ? 'ours' : 'theirs';
    await this.props.repository.checkoutSide(side, paths);
    this.refreshResolutionProgress(false, true);
  }

  checkout(branchName, options) {
    return this.props.repository.checkout(branchName, options);
  }

  rememberLastFocus(event) {
    this.lastFocus = this.refView.map(view => view.rememberFocus(event)).getOr(null) || _gitTabView2.default.focus.STAGING;
  }

  restoreFocus() {
    this.refView.map(view => view.setFocus(this.lastFocus));
  }

  hasFocus() {
    return this.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

  wasActivated(isStillActive) {
    process.nextTick(() => {
      isStillActive() && this.restoreFocus();
    });
  }

  focusAndSelectStagingItem(filePath, stagingStatus) {
    return this.refView.map(view => view.focusAndSelectStagingItem(filePath, stagingStatus)).getOr(null);
  }

  focusAndSelectCommitPreviewButton() {
    return this.refView.map(view => view.focusAndSelectCommitPreviewButton());
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.refView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(null);
  }
}
exports.default = GitTabController;
GitTabController.focus = _extends({}, _gitTabView2.default.focus);
GitTabController.propTypes = {
  repository: _propTypes2.default.object.isRequired,
  loginModel: _propTypes2.default.object.isRequired,

  lastCommit: _propTypes3.CommitPropType.isRequired,
  recentCommits: _propTypes2.default.arrayOf(_propTypes3.CommitPropType).isRequired,
  isMerging: _propTypes2.default.bool.isRequired,
  isRebasing: _propTypes2.default.bool.isRequired,
  hasUndoHistory: _propTypes2.default.bool.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  unstagedChanges: _propTypes2.default.arrayOf(_propTypes3.FilePatchItemPropType).isRequired,
  stagedChanges: _propTypes2.default.arrayOf(_propTypes3.FilePatchItemPropType).isRequired,
  mergeConflicts: _propTypes2.default.arrayOf(_propTypes3.MergeConflictItemPropType).isRequired,
  workingDirectoryPath: _propTypes2.default.string,
  mergeMessage: _propTypes2.default.string,
  fetchInProgress: _propTypes2.default.bool.isRequired,

  workspace: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  grammars: _propTypes2.default.object.isRequired,
  resolutionProgress: _propTypes2.default.object.isRequired,
  notificationManager: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,
  project: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,

  confirm: _propTypes2.default.func.isRequired,
  ensureGitTab: _propTypes2.default.func.isRequired,
  refreshResolutionProgress: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired,
  initializeRepo: _propTypes2.default.func.isRequired,
  controllerRef: _propTypes3.RefHolderPropType
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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