'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _helpers = require('../helpers');

var _source = require('../models/conflicts/source');

var _decoration = require('../atom/decoration');

var _decoration2 = _interopRequireDefault(_decoration);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const { Menu, MenuItem } = _electron.remote;

class ConflictController extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'showResolveMenu');

    this.state = {
      chosenSide: this.props.conflict.getChosenSide()
    };
  }

  resolveAsSequence(sources) {
    this.props.resolveAsSequence(sources);

    this.setState({
      chosenSide: this.props.conflict.getChosenSide()
    });
  }

  revert(side) {
    side.isModified() && side.revert();
    side.isBannerModified() && side.revertBanner();
  }

  showResolveMenu(event) {
    event.preventDefault();

    const menu = new Menu();

    menu.append(new MenuItem({
      label: 'Resolve as Ours',
      click: this.resolveAsSequence.bind(this, [_source.OURS])
    }));

    if (this.props.conflict.getSide(_source.BASE)) {
      menu.append(new MenuItem({
        label: 'Resolve as Base',
        click: this.resolveAsSequence.bind(this, [_source.BASE])
      }));
    }

    menu.append(new MenuItem({
      label: 'Resolve as Theirs',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Resolve as Ours Then Theirs',
      click: this.resolveAsSequence.bind(this, [_source.OURS, _source.THEIRS])
    }));
    menu.append(new MenuItem({
      label: 'Resolve as Theirs Then Ours',
      click: this.resolveAsSequence.bind(this, [_source.THEIRS, _source.OURS])
    }));

    menu.append(new MenuItem({ type: 'separator' }));

    menu.append(new MenuItem({
      label: 'Dismiss',
      click: this.props.dismiss
    }));

    menu.popup(_electron.remote.getCurrentWindow());
  }

  render() {
    if (!this.state.chosenSide) {
      const ours = this.props.conflict.getSide(_source.OURS);
      const base = this.props.conflict.getSide(_source.BASE);
      const theirs = this.props.conflict.getSide(_source.THEIRS);

      return _react2.default.createElement(
        'div',
        null,
        this.renderSide(ours),
        base && this.renderSide(base),
        _react2.default.createElement(_decoration2.default, {
          key: this.props.conflict.getSeparator().getMarker().id,
          editor: this.props.editor,
          decorable: this.props.conflict.getSeparator().getMarker(),
          type: 'line',
          className: 'github-ConflictSeparator'
        }),
        this.renderSide(theirs)
      );
    } else if (!this.state.chosenSide.isEmpty()) {
      return _react2.default.createElement(_decoration2.default, {
        editor: this.props.editor,
        decorable: this.state.chosenSide.getMarker(),
        type: 'line',
        className: 'github-ResolvedLines'
      });
    } else {
      return null;
    }
  }

  renderSide(side) {
    const source = side.getSource();

    return _react2.default.createElement(
      'div',
      null,
      _react2.default.createElement(_decoration2.default, {
        key: side.banner.marker.id,
        editor: this.props.editor,
        decorable: side.getBannerMarker(),
        type: 'line',
        className: side.getBannerCSSClass()
      }),
      side.isBannerModified() || _react2.default.createElement(_decoration2.default, {
        key: 'banner-modified-' + side.banner.marker.id,
        editor: this.props.editor,
        decorable: side.getBannerMarker(),
        type: 'line',
        className: 'github-ConflictUnmodifiedBanner'
      }),
      _react2.default.createElement(_decoration2.default, {
        key: side.marker.id,
        editor: this.props.editor,
        decorable: side.getMarker(),
        type: 'line',
        className: side.getLineCSSClass()
      }),
      _react2.default.createElement(
        _decoration2.default,
        {
          key: 'block-' + side.marker.id,
          editor: this.props.editor,
          decorable: side.getBlockMarker(),
          type: 'block',
          position: side.getBlockPosition() },
        _react2.default.createElement(
          'div',
          { className: side.getBlockCSSClasses() },
          _react2.default.createElement(
            'span',
            { className: 'github-ResolutionControls' },
            _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.resolveAsSequence([source]) },
              'Use me'
            ),
            (side.isModified() || side.isBannerModified()) && _react2.default.createElement(
              'button',
              { className: 'btn btn-sm inline-block', onClick: () => this.revert(side) },
              'Revert'
            ),
            _react2.default.createElement(_octicon2.default, { icon: 'ellipses', className: 'inline-block', onClick: this.showResolveMenu })
          ),
          _react2.default.createElement(
            'span',
            { className: 'github-SideDescription' },
            source.toUIString()
          )
        )
      )
    );
  }
}
exports.default = ConflictController;
ConflictController.propTypes = {
  editor: _propTypes2.default.object.isRequired,
  conflict: _propTypes2.default.object.isRequired,
  resolveAsSequence: _propTypes2.default.func,
  dismiss: _propTypes2.default.func
};
ConflictController.defaultProps = {
  resolveAsSequence: sources => {},
  dismiss: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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