'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ContextMenuInterceptor extends _react2.default.Component {

  static handle(event) {
    for (const [element, callback] of ContextMenuInterceptor.registration) {
      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, { capture: true });
  }

  componentDidMount() {
    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, { capture: true });
    ContextMenuInterceptor.registration.set(this.element, (...args) => this.props.onWillShowContextMenu(...args));
  }

  render() {
    return _react2.default.createElement(
      'div',
      { ref: e => {
          this.element = e;
        } },
      this.props.children
    );
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration.delete(this.element);
  }
}

exports.default = ContextMenuInterceptor;
ContextMenuInterceptor.propTypes = {
  onWillShowContextMenu: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.element.isRequired
};
ContextMenuInterceptor.registration = new Map();
function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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