'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class UserMentionTooltip extends _react2.default.Component {

  render() {
    const owner = this.props.repositoryOwner;
    const { login, company, repositories, members } = owner;
    return _react2.default.createElement(
      'div',
      { className: 'github-UserMentionTooltip' },
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-avatar' },
        _react2.default.createElement('img', { alt: 'repository owner\'s avatar', src: owner.avatarUrl })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-info' },
        _react2.default.createElement(
          'div',
          { className: 'github-UserMentionTooltip-info-username' },
          _react2.default.createElement(_octicon2.default, { icon: 'mention' }),
          _react2.default.createElement(
            'strong',
            null,
            login
          )
        ),
        company && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'briefcase' }),
          _react2.default.createElement(
            'span',
            null,
            company
          )
        ),
        members && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'organization' }),
          _react2.default.createElement(
            'span',
            null,
            members.totalCount,
            ' members'
          )
        ),
        _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'repo' }),
          _react2.default.createElement(
            'span',
            null,
            repositories.totalCount,
            ' repositories'
          )
        )
      ),
      _react2.default.createElement('div', { style: { clear: 'both' } })
    );
  }
}

UserMentionTooltip.propTypes = {
  repositoryOwner: _propTypes2.default.shape({
    login: _propTypes2.default.string.isRequired,
    avatarUrl: _propTypes2.default.string.isRequired,
    repositories: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired,

    // Users
    company: _propTypes2.default.string,

    // Organizations
    members: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    })
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(UserMentionTooltip, {
  repositoryOwner: function () {
    const node = require('./__generated__/userMentionTooltipContainer_repositoryOwner.graphql');

    if (node.hash && node.hash !== 'e59070cd60b11e3732403a074496e66c') {
      console.error('The definition of \'userMentionTooltipContainer_repositoryOwner\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/userMentionTooltipContainer_repositoryOwner.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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