'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _reporterProxy = require('../reporter-proxy');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _keytarStrategy = require('../shared/keytar-strategy');

var _remoteController = require('../controllers/remote-controller');

var _remoteController2 = _interopRequireDefault(_remoteController);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _queryErrorView = require('../views/query-error-view');

var _queryErrorView2 = _interopRequireDefault(_queryErrorView);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RemoteContainer extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return loginModel.getToken(this.props.host);
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchToken },
      this.renderWithToken
    );
  }

  renderWithToken(token) {
    if (token === null) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (token === _keytarStrategy.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    if (token === _keytarStrategy.INSUFFICIENT) {
      return _react2.default.createElement(
        _githubLoginView2.default,
        { onLogin: this.handleLogin },
        _react2.default.createElement(
          'p',
          null,
          'Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one.'
        )
      );
    }

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, token);
    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/remoteContainerQuery.graphql');

      if (node.hash && node.hash !== 'b83aa6c27c5d7e1c499badf2e6bfab6b') {
        console.error('The definition of \'remoteContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/remoteContainerQuery.graphql');
    });
    const variables = {
      owner: this.props.remote.getOwner(),
      name: this.props.remote.getRepo()
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: result => this.renderWithResult(result, token)
    });
  }

  renderWithResult({ error, props, retry }, token) {
    if (error) {
      return _react2.default.createElement(_queryErrorView2.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    return _react2.default.createElement(_remoteController2.default, {
      host: this.props.host,
      token: token,

      repository: props.repository,

      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,

      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,

      onPushBranch: this.props.onPushBranch
    });
  }

  handleLogin(token) {
    (0, _reporterProxy.incrementCounter)('github-login');
    this.props.loginModel.setToken(this.props.host, token);
  }

  handleLogout() {
    (0, _reporterProxy.incrementCounter)('github-logout');
    this.props.loginModel.removeToken(this.props.host);
  }
}
exports.default = RemoteContainer;
RemoteContainer.propTypes = {
  loginModel: _propTypes2.default.object.isRequired,

  host: _propTypes2.default.string.isRequired,

  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  workspace: _propTypes2.default.object.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,

  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onPushBranch: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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