'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _issueishListController = require('../controllers/issueish-list-controller');

var _issueishListController2 = _interopRequireDefault(_issueishListController);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishSearchContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');

    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, this.props.token);

    if (this.props.search.isNull()) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/issueishSearchContainerQuery.graphql');

      if (node.hash && node.hash !== 'fc553ba742c51417ea1a857b96038345') {
        console.error('The definition of \'issueishSearchContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/issueishSearchContainerQuery.graphql');
    });
    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({ error, props, retry }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react2.default.createElement(_issueishListController2.default, _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),

      onOpenIssueish: this.props.onOpenIssueish,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }
}
exports.default = IssueishSearchContainer;
IssueishSearchContainer.propTypes = {
  token: _propTypes2.default.string.isRequired,
  host: _propTypes2.default.string.isRequired,
  limit: _propTypes2.default.number,
  search: _propTypes3.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,

  onOpenIssueish: _propTypes2.default.func.isRequired,
  onOpenSearch: _propTypes2.default.func.isRequired
};
IssueishSearchContainer.defaultProps = {
  limit: 20
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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