'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _reactRelay = require('react-relay');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _propTypes3 = require('../prop-types');

var _keytarStrategy = require('../shared/keytar-strategy');

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _queryErrorView = require('../views/query-error-view');

var _queryErrorView2 = _interopRequireDefault(_queryErrorView);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _issueishDetailController = require('../controllers/issueish-detail-controller');

var _issueishDetailController2 = _interopRequireDefault(_issueishDetailController);

var _relayEnvironment = require('../views/relay-environment');

var _relayEnvironment2 = _interopRequireDefault(_relayEnvironment);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishDetailContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'fetchRepositoryData', 'renderWithRepositoryData', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return (0, _yubikiri2.default)({
      token: loginModel.getToken(this.props.host)
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchToken },
      this.renderWithToken
    );
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri2.default)({
      branches: repository.getBranches(),
      remotes: repository.getRemotes(),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      isAbsent: repository.isAbsent(),
      isLoading: repository.isLoading(),
      isPresent: repository.isPresent()
    });
  }

  renderWithToken(tokenData) {
    if (!tokenData) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (tokenData.token === _keytarStrategy.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    if (tokenData.token === _keytarStrategy.INSUFFICIENT) {
      return _react2.default.createElement(
        _githubLoginView2.default,
        { onLogin: this.handleLogin },
        _react2.default.createElement(
          'p',
          null,
          'Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one.'
        )
      );
    }

    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchRepositoryData },
      repoData => this.renderWithRepositoryData(repoData, tokenData.token)
    );
  }

  renderWithRepositoryData(repoData, token) {
    if (!repoData) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, token);
    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/issueishDetailContainerQuery.graphql');

      if (node.hash && node.hash !== 'a7a95576735d58263820790226b82e2f') {
        console.error('The definition of \'issueishDetailContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/issueishDetailContainerQuery.graphql');
    });
    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      timelineCount: 100,
      timelineCursor: null,
      commitCount: 100,
      commitCursor: null
    };

    return _react2.default.createElement(
      _relayEnvironment2.default.Provider,
      { value: environment },
      _react2.default.createElement(_reactRelay.QueryRenderer, {
        environment: environment,
        query: query,
        variables: variables,
        render: queryResult => this.renderWithResult(queryResult, repoData)
      })
    );
  }

  renderWithResult({ error, props, retry }, repoData) {
    if (error) {
      return _react2.default.createElement(_queryErrorView2.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    const { repository } = this.props;

    return _react2.default.createElement(_issueishDetailController2.default, _extends({}, props, repoData, {
      issueishNumber: this.props.issueishNumber,
      fetch: repository.fetch.bind(repository),
      checkout: repository.checkout.bind(repository),
      pull: repository.pull.bind(repository),
      addRemote: repository.addRemote.bind(repository),
      onTitleChange: this.props.onTitleChange,
      switchToIssueish: this.props.switchToIssueish
    }));
  }

  handleLogin(token) {
    return this.props.loginModel.setToken(this.props.host, token);
  }

  handleLogout() {
    return this.props.loginModel.removeToken(this.props.host);
  }
}
exports.default = IssueishDetailContainer;
IssueishDetailContainer.propTypes = {
  host: _propTypes2.default.string,
  owner: _propTypes2.default.string.isRequired,
  repo: _propTypes2.default.string.isRequired,
  issueishNumber: _propTypes2.default.number.isRequired,

  repository: _propTypes2.default.object.isRequired,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,

  switchToIssueish: _propTypes2.default.func.isRequired,
  onTitleChange: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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