'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _helpers = require('../helpers');

var _commit = require('../models/commit');

var _branch = require('../models/branch');

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _gitTabController = require('../controllers/git-tab-controller');

var _gitTabController2 = _interopRequireDefault(_gitTabController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const DEFAULT_REPO_DATA = {
  lastCommit: _commit.nullCommit,
  recentCommits: [],
  isMerging: false,
  isRebasing: false,
  hasUndoHistory: false,
  currentBranch: _branch.nullBranch,
  unstagedChanges: [],
  stagedChanges: [],
  mergeConflicts: [],
  workingDirectoryPath: null,
  mergeMessage: null,
  fetchInProgress: true
};

class GitTabContainer extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'fetchData');
  }

  fetchData(repository) {
    return (0, _yubikiri2.default)({
      lastCommit: repository.getLastCommit(),
      recentCommits: repository.getRecentCommits({ max: 10 }),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      hasUndoHistory: repository.hasDiscardHistory(),
      currentBranch: repository.getCurrentBranch(),
      unstagedChanges: repository.getUnstagedChanges(),
      stagedChanges: repository.getStagedChanges(),
      mergeConflicts: repository.getMergeConflicts(),
      workingDirectoryPath: repository.getWorkingDirectoryPath(),
      mergeMessage: async query => {
        const isMerging = await query.isMerging;
        return isMerging ? repository.getMergeMessage() : null;
      },
      fetchInProgress: false
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      data => _react2.default.createElement(_gitTabController2.default, _extends({}, this.props, data || DEFAULT_REPO_DATA))
    );
  }
}
exports.default = GitTabContainer;
GitTabContainer.propTypes = {
  repository: _propTypes2.default.object.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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