'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _issueishListController = require('../controllers/issueish-list-controller');

var _issueishListController2 = _interopRequireDefault(_issueishListController);

var _createPullRequestTile = require('../views/create-pull-request-tile');

var _createPullRequestTile2 = _interopRequireDefault(_createPullRequestTile);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CurrentPullRequestContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');

    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, this.props.token);

    const head = this.props.branches.getHeadBranch();
    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }
    const push = head.getPush();
    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }
    const pushRemote = this.props.remotes.withName(push.getRemoteName());
    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/currentPullRequestContainerQuery.graphql');

      if (node.hash && node.hash !== 'ade50c0777277f2032b27dfced670a2d') {
        console.error('The definition of \'currentPullRequestContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/currentPullRequestContainerQuery.graphql');
    });
    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());

    return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({ isLoading: false }, this.controllerProps()));
  }

  renderQueryResult({ error, props, retry }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({ isLoading: false }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;

    return _react2.default.createElement(_issueishListController2.default, _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react2.default.createElement(_createPullRequestTile2.default, {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      emptyComponent: this.renderEmptyTile
    };
  }
}
exports.default = CurrentPullRequestContainer;
CurrentPullRequestContainer.propTypes = {
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }).isRequired,

  token: _propTypes2.default.string.isRequired,
  host: _propTypes2.default.string.isRequired,
  limit: _propTypes2.default.number,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  onOpenIssueish: _propTypes2.default.func.isRequired,
  onCreatePr: _propTypes2.default.func.isRequired
};
CurrentPullRequestContainer.defaultProps = {
  limit: 5
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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