'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _helpers = require('../helpers');

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _changedFileController = require('../controllers/changed-file-controller');

var _changedFileController2 = _interopRequireDefault(_changedFileController);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class ChangedFileContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchData', 'renderWithData');
  }

  fetchData(repository) {
    const staged = this.props.stagingStatus === 'staged';

    return (0, _yubikiri2.default)({
      multiFilePatch: repository.getFilePatchForPath(this.props.relPath, { staged }),
      isPartiallyStaged: repository.isPartiallyStaged(this.props.relPath),
      hasUndoHistory: repository.hasDiscardHistory(this.props.relPath)
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchData },
      this.renderWithData
    );
  }

  renderWithData(data) {
    if (this.props.repository.isLoading() || data === null) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    return _react2.default.createElement(_changedFileController2.default, _extends({}, data, this.props));
  }
}
exports.default = ChangedFileContainer;
ChangedFileContainer.propTypes = {
  repository: _propTypes2.default.object.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['staged', 'unstaged']),
  relPath: _propTypes2.default.string.isRequired,

  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  destroy: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  surfaceFileAtPath: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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