'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const VERBATIM_OPTION_PROPS = ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'];

const OPTION_PROPS = [...VERBATIM_OPTION_PROPS, 'tooltips', 'className', 'showDelay', 'hideDelay'];

class Tooltip extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.refSub = new _eventKit.Disposable();
    this.tipSub = new _eventKit.Disposable();

    this.domNode = null;
    if (this.props.children !== undefined) {
      this.domNode = document.createElement('div');
      this.domNode.className = 'react-atom-tooltip';
    }

    this.lastTooltipProps = {};
  }

  componentDidMount() {
    this.setupTooltip();
  }

  render() {
    if (this.props.children !== undefined) {
      return _reactDom2.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  componentDidUpdate() {
    if (this.shouldRecreateTooltip()) {
      this.refSub.dispose();
      this.tipSub.dispose();
      this.setupTooltip();
    }
  }

  componentWillUnmount() {
    this.refSub.dispose();
    this.tipSub.dispose();
  }

  getTooltipProps() {
    const p = {};
    for (const key of OPTION_PROPS) {
      p[key] = this.props[key];
    }
    return p;
  }

  shouldRecreateTooltip() {
    return OPTION_PROPS.some(key => this.lastTooltipProps[key] !== this.props[key]);
  }

  setupTooltip() {
    this.lastTooltipProps = this.getTooltipProps();

    const options = {};
    VERBATIM_OPTION_PROPS.forEach(key => {
      if (this.props[key] !== undefined) {
        options[key] = this.props[key];
      }
    });
    if (this.props.className !== undefined) {
      options.class = this.props.className;
    }
    if (this.props.showDelay !== undefined || this.props.hideDelay !== undefined) {
      const delayDefaults = (this.props.trigger === 'hover' || this.props.trigger === undefined) && { show: 1000, hide: 100 } || { show: 0, hide: 0 };

      options.delay = {
        show: this.props.showDelay !== undefined ? this.props.showDelay : delayDefaults.show,
        hide: this.props.hideDelay !== undefined ? this.props.hideDelay : delayDefaults.hide
      };
    }
    if (this.props.children !== undefined) {
      options.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    this.refSub = this.props.target.observe(t => {
      this.tipSub.dispose();
      this.tipSub = this.props.manager.add(t, options);
    });
  }
}
exports.default = Tooltip;
Tooltip.propTypes = {
  manager: _propTypes2.default.object.isRequired,
  target: _propTypes3.RefHolderPropType.isRequired,
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  html: _propTypes2.default.bool,
  className: _propTypes2.default.string,
  placement: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  trigger: _propTypes2.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes2.default.number,
  hideDelay: _propTypes2.default.number,
  keyBindingCommand: _propTypes2.default.string,
  keyBindingTarget: _propTypes2.default.element,
  children: _propTypes2.default.element,
  itemHolder: _propTypes3.RefHolderPropType
};
Tooltip.defaultProps = {
  getItemComponent: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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