'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class StatusBar extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.domNode = document.createElement('div');
    this.domNode.classList.add('react-atom-status-bar');
    if (props.className) {
      this.domNode.classList.add(props.className);
    }
    this.tile = null;
  }

  componentDidMount() {
    this.consumeStatusBar();
  }

  render() {
    return _reactDom2.default.createPortal(this.props.children, this.domNode);
  }

  consumeStatusBar() {
    if (this.tile) {
      return;
    }
    if (!this.props.statusBar) {
      return;
    }

    this.tile = this.props.statusBar.addRightTile({ item: this.domNode, priority: -50 });
    this.props.onConsumeStatusBar(this.props.statusBar);
  }

  componentWillUnmount() {
    this.tile && this.tile.destroy();
  }
}
exports.default = StatusBar;
StatusBar.propTypes = {
  children: _propTypes2.default.element.isRequired,
  statusBar: _propTypes2.default.object,
  onConsumeStatusBar: _propTypes2.default.func,
  className: _propTypes2.default.string
};
StatusBar.defaultProps = {
  onConsumeStatusBar: statusBar => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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