'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerLayerContext = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _atomTextEditor = require('./atom-text-editor');

var _marker = require('./marker');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const markerLayerProps = {
  maintainHistory: _propTypes2.default.bool,
  persistent: _propTypes2.default.bool
};

const MarkerLayerContext = exports.MarkerLayerContext = _react2.default.createContext();

class BareMarkerLayer extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'createLayer');

    this.subs = new _eventKit.CompositeDisposable();
    this.layerSub = new _eventKit.Disposable();

    this.layerHolder = new _refHolder2.default();
    this.state = {
      editorHolder: _refHolder2.default.on(this.props.editor)
    };

    this.decorable = {
      holder: this.layerHolder,
      decorateMethod: 'decorateMarkerLayer'
    };
  }

  static getDerivedStateFromProps(props, state) {
    if (state.editorHolder.map(e => e === props.editor).getOr(props.editor === undefined)) {
      return null;
    }

    return {
      editorHolder: _refHolder2.default.on(props.editor)
    };
  }

  componentDidMount() {
    this.observeEditor();
  }

  render() {
    return _react2.default.createElement(
      MarkerLayerContext.Provider,
      { value: this.layerHolder },
      _react2.default.createElement(
        _marker.DecorableContext.Provider,
        { value: this.decorable },
        this.props.children
      )
    );
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.state.editorHolder !== prevState.editorHolder) {
      this.observeEditor();
    }
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  observeEditor() {
    this.subs.dispose();
    this.subs = new _eventKit.CompositeDisposable();
    this.subs.add(this.state.editorHolder.observe(this.createLayer));
  }

  createLayer() {
    this.subs.remove(this.layerSub);
    this.layerSub.dispose();

    this.state.editorHolder.map(editor => {
      const options = (0, _helpers.extractProps)(this.props, markerLayerProps);
      let layer;
      if (this.props.external !== undefined) {
        layer = editor.getMarkerLayer(this.props.external.id);
        if (!layer) {
          return null;
        }
        if (layer !== this.props.external && layer.bufferMarkerLayer !== this.props.external) {
          // Oops, same layer ID on a different TextEditor
          return null;
        }
        this.layerSub = new _eventKit.Disposable();
      } else {
        layer = editor.addMarkerLayer(options);
        this.layerSub = new _eventKit.Disposable(() => {
          layer.destroy();
          this.props.handleLayer(undefined);
          this.props.handleID(undefined);
        });
      }
      this.layerHolder.setter(layer);

      this.props.handleLayer(layer);
      this.props.handleID(layer.id);

      this.subs.add(this.layerSub);

      return null;
    });
  }
}

BareMarkerLayer.propTypes = _extends({}, markerLayerProps, {
  editor: _propTypes2.default.object,
  external: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired
  }),
  children: _propTypes2.default.node,
  handleID: _propTypes2.default.func,
  handleLayer: _propTypes2.default.func
});
BareMarkerLayer.defaultProps = {
  handleID: () => {},
  handleLayer: () => {}
};
class MarkerLayer extends _react2.default.Component {
  render() {
    return _react2.default.createElement(
      _atomTextEditor.TextEditorContext.Consumer,
      null,
      editor => _react2.default.createElement(BareMarkerLayer, _extends({ editor: editor }, this.props))
    );
  }
}
exports.default = MarkerLayer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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