'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _atomTextEditor = require('./atom-text-editor');

var _marker = require('./marker');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const decorationPropTypes = {
  type: _propTypes2.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes2.default.string,
  style: _propTypes2.default.string,
  onlyHead: _propTypes2.default.bool,
  onlyEmpty: _propTypes2.default.bool,
  onlyNonEmpty: _propTypes2.default.bool,
  omitEmptyLastRow: _propTypes2.default.bool,
  position: _propTypes2.default.oneOf(['head', 'tail', 'before', 'after']),
  avoidOverflow: _propTypes2.default.bool,
  gutterName: _propTypes2.default.string
};

class BareDecoration extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    (0, _helpers.autobind)(this, 'observeParents');

    this.decorationHolder = new _refHolder2.default();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();

    this.domNode = null;
    this.item = null;
    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames2.default)('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.state.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.state.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      const opts = this.getDecorationOpts(this.props);
      this.decorationHolder.map(decoration => decoration.setProperties(opts));
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom2.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  observeParents() {
    this.decorationHolder.map(decoration => decoration.destroy());

    const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
    const markableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false);

    // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor
    const markableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
      const layer = decorable.layer || decorable;
      const displayLayer = editor.getMarkerLayer(layer.id);
      if (!displayLayer) {
        return false;
      }
      if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
        return false;
      }
      return true;
    }).getOr(false)).getOr(false);

    if (!editorValid || !markableValid || !markableMatches) {
      return;
    }

    this.createDecoration();
  }

  createDecoration() {
    if (!this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();

    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
  }

  getDecorationOpts(props) {
    return _extends({}, (0, _helpers.extractProps)(props, decorationPropTypes, { className: 'class' }), {
      item: this.item
    });
  }
}

BareDecoration.propTypes = _extends({
  editorHolder: _propTypes3.RefHolderPropType.isRequired,
  decorableHolder: _propTypes3.RefHolderPropType.isRequired,
  decorateMethod: _propTypes2.default.oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes3.RefHolderPropType,
  children: _propTypes2.default.node
}, decorationPropTypes);
BareDecoration.defaultProps = {
  decorateMethod: 'decorateMarker'
};
class Decoration extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.state = {
      editorHolder: _refHolder2.default.on(this.props.editor),
      decorableHolder: _refHolder2.default.on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};
    if (editorChanged) {
      nextState.editorHolder = _refHolder2.default.on(props.editor);
    }
    if (decorableChanged) {
      nextState.decorableHolder = _refHolder2.default.on(props.decorable);
    }
    return nextState;
  }

  render() {
    if (!this.state.editorHolder.isEmpty() && !this.state.decorableHolder.isEmpty()) {
      return _react2.default.createElement(BareDecoration, _extends({}, this.props, {
        editorHolder: this.state.editorHolder,
        decorableHolder: this.state.decorableHolder
      }));
    }

    return _react2.default.createElement(
      _atomTextEditor.TextEditorContext.Consumer,
      null,
      editorHolder => _react2.default.createElement(
        _marker.DecorableContext.Consumer,
        null,
        ({ holder, decorateMethod }) => _react2.default.createElement(BareDecoration, _extends({
          editorHolder: editorHolder,
          decorableHolder: holder,
          decorateMethod: decorateMethod
        }, this.props))
      )
    );
  }
}
exports.default = Decoration;
Decoration.propTypes = {
  editor: _propTypes2.default.object,
  decorable: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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