'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Command = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Commands extends _react2.default.Component {

  render() {
    const { registry, target } = this.props;
    return _react2.default.createElement(
      'div',
      null,
      _react2.default.Children.map(this.props.children, child => {
        return child ? _react2.default.cloneElement(child, { registry, target }) : null;
      })
    );
  }
}

exports.default = Commands;
Commands.propTypes = {
  registry: _propTypes2.default.object.isRequired,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType, _propTypes3.RefHolderPropType]).isRequired,
  children: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.arrayOf(_propTypes2.default.element)]).isRequired
};
class Command extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.subTarget = new _eventKit.Disposable();
    this.subCommand = new _eventKit.Disposable();
  }

  componentDidMount() {
    this.observeTarget(this.props);
  }

  componentWillReceiveProps(newProps) {
    if (['registry', 'target', 'command', 'callback'].some(p => newProps[p] !== this.props[p])) {
      this.observeTarget(newProps);
    }
  }

  componentWillUnmount() {
    this.subTarget.dispose();
    this.subCommand.dispose();
  }

  observeTarget(props) {
    this.subTarget.dispose();
    this.subTarget = _refHolder2.default.on(props.target).observe(t => this.registerCommand(t, props));
  }

  registerCommand(target, { registry, command, callback }) {
    this.subCommand.dispose();
    this.subCommand = registry.add(target, command, callback);
  }

  render() {
    return null;
  }
}
exports.Command = Command;
Command.propTypes = {
  registry: _propTypes2.default.object,
  target: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes3.DOMNodePropType, _propTypes3.RefHolderPropType]),
  command: _propTypes2.default.string.isRequired,
  callback: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbW1hbmRzLmpzIl0sIm5hbWVzIjpbIkNvbW1hbmRzIiwiUmVhY3QiLCJDb21wb25lbnQiLCJyZW5kZXIiLCJyZWdpc3RyeSIsInRhcmdldCIsInByb3BzIiwiQ2hpbGRyZW4iLCJtYXAiLCJjaGlsZHJlbiIsImNoaWxkIiwiY2xvbmVFbGVtZW50IiwicHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwib2JqZWN0IiwiaXNSZXF1aXJlZCIsIm9uZU9mVHlwZSIsInN0cmluZyIsIkRPTU5vZGVQcm9wVHlwZSIsIlJlZkhvbGRlclByb3BUeXBlIiwiZWxlbWVudCIsImFycmF5T2YiLCJDb21tYW5kIiwiY29uc3RydWN0b3IiLCJjb250ZXh0Iiwic3ViVGFyZ2V0IiwiRGlzcG9zYWJsZSIsInN1YkNvbW1hbmQiLCJjb21wb25lbnREaWRNb3VudCIsIm9ic2VydmVUYXJnZXQiLCJjb21wb25lbnRXaWxsUmVjZWl2ZVByb3BzIiwibmV3UHJvcHMiLCJzb21lIiwicCIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwiZGlzcG9zZSIsIlJlZkhvbGRlciIsIm9uIiwib2JzZXJ2ZSIsInQiLCJyZWdpc3RlckNvbW1hbmQiLCJjb21tYW5kIiwiY2FsbGJhY2siLCJhZGQiLCJmdW5jIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFDQTs7OztBQUNBOztBQUVBOztBQUNBOzs7Ozs7QUFFZSxNQUFNQSxRQUFOLFNBQXVCQyxnQkFBTUMsU0FBN0IsQ0FBdUM7O0FBY3BEQyxXQUFTO0FBQ1AsVUFBTSxFQUFDQyxRQUFELEVBQVdDLE1BQVgsS0FBcUIsS0FBS0MsS0FBaEM7QUFDQSxXQUNFO0FBQUE7QUFBQTtBQUNHTCxzQkFBTU0sUUFBTixDQUFlQyxHQUFmLENBQW1CLEtBQUtGLEtBQUwsQ0FBV0csUUFBOUIsRUFBd0NDLFNBQVM7QUFDaEQsZUFBT0EsUUFBUVQsZ0JBQU1VLFlBQU4sQ0FBbUJELEtBQW5CLEVBQTBCLEVBQUNOLFFBQUQsRUFBV0MsTUFBWCxFQUExQixDQUFSLEdBQXdELElBQS9EO0FBQ0QsT0FGQTtBQURILEtBREY7QUFPRDtBQXZCbUQ7O2tCQUFqQ0wsUTtBQUFBQSxRLENBQ1pZLFMsR0FBWTtBQUNqQlIsWUFBVVMsb0JBQVVDLE1BQVYsQ0FBaUJDLFVBRFY7QUFFakJWLFVBQVFRLG9CQUFVRyxTQUFWLENBQW9CLENBQzFCSCxvQkFBVUksTUFEZ0IsRUFFMUJDLDJCQUYwQixFQUcxQkMsNkJBSDBCLENBQXBCLEVBSUxKLFVBTmM7QUFPakJOLFlBQVVJLG9CQUFVRyxTQUFWLENBQW9CLENBQzVCSCxvQkFBVU8sT0FEa0IsRUFFNUJQLG9CQUFVUSxPQUFWLENBQWtCUixvQkFBVU8sT0FBNUIsQ0FGNEIsQ0FBcEIsRUFHUEw7QUFWYyxDO0FBeUJkLE1BQU1PLE9BQU4sU0FBc0JyQixnQkFBTUMsU0FBNUIsQ0FBc0M7O0FBWTNDcUIsY0FBWWpCLEtBQVosRUFBbUJrQixPQUFuQixFQUE0QjtBQUMxQixVQUFNbEIsS0FBTixFQUFha0IsT0FBYjtBQUNBLFNBQUtDLFNBQUwsR0FBaUIsSUFBSUMsb0JBQUosRUFBakI7QUFDQSxTQUFLQyxVQUFMLEdBQWtCLElBQUlELG9CQUFKLEVBQWxCO0FBQ0Q7O0FBRURFLHNCQUFvQjtBQUNsQixTQUFLQyxhQUFMLENBQW1CLEtBQUt2QixLQUF4QjtBQUNEOztBQUVEd0IsNEJBQTBCQyxRQUExQixFQUFvQztBQUNsQyxRQUFJLENBQUMsVUFBRCxFQUFhLFFBQWIsRUFBdUIsU0FBdkIsRUFBa0MsVUFBbEMsRUFBOENDLElBQTlDLENBQW1EQyxLQUFLRixTQUFTRSxDQUFULE1BQWdCLEtBQUszQixLQUFMLENBQVcyQixDQUFYLENBQXhFLENBQUosRUFBNEY7QUFDMUYsV0FBS0osYUFBTCxDQUFtQkUsUUFBbkI7QUFDRDtBQUNGOztBQUVERyx5QkFBdUI7QUFDckIsU0FBS1QsU0FBTCxDQUFlVSxPQUFmO0FBQ0EsU0FBS1IsVUFBTCxDQUFnQlEsT0FBaEI7QUFDRDs7QUFFRE4sZ0JBQWN2QixLQUFkLEVBQXFCO0FBQ25CLFNBQUttQixTQUFMLENBQWVVLE9BQWY7QUFDQSxTQUFLVixTQUFMLEdBQWlCVyxvQkFBVUMsRUFBVixDQUFhL0IsTUFBTUQsTUFBbkIsRUFBMkJpQyxPQUEzQixDQUFtQ0MsS0FBSyxLQUFLQyxlQUFMLENBQXFCRCxDQUFyQixFQUF3QmpDLEtBQXhCLENBQXhDLENBQWpCO0FBQ0Q7O0FBRURrQyxrQkFBZ0JuQyxNQUFoQixFQUF3QixFQUFDRCxRQUFELEVBQVdxQyxPQUFYLEVBQW9CQyxRQUFwQixFQUF4QixFQUF1RDtBQUNyRCxTQUFLZixVQUFMLENBQWdCUSxPQUFoQjtBQUNBLFNBQUtSLFVBQUwsR0FBa0J2QixTQUFTdUMsR0FBVCxDQUFhdEMsTUFBYixFQUFxQm9DLE9BQXJCLEVBQThCQyxRQUE5QixDQUFsQjtBQUNEOztBQUVEdkMsV0FBUztBQUNQLFdBQU8sSUFBUDtBQUNEO0FBN0MwQztRQUFoQ21CLE8sR0FBQUEsTztBQUFBQSxPLENBQ0pWLFMsR0FBWTtBQUNqQlIsWUFBVVMsb0JBQVVDLE1BREg7QUFFakJULFVBQVFRLG9CQUFVRyxTQUFWLENBQW9CLENBQzFCSCxvQkFBVUksTUFEZ0IsRUFFMUJDLDJCQUYwQixFQUcxQkMsNkJBSDBCLENBQXBCLENBRlM7QUFPakJzQixXQUFTNUIsb0JBQVVJLE1BQVYsQ0FBaUJGLFVBUFQ7QUFRakIyQixZQUFVN0Isb0JBQVUrQixJQUFWLENBQWU3QjtBQVJSLEMiLCJmaWxlIjoiY29tbWFuZHMuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNC4wL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvYXRvbSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuXG5pbXBvcnQge0RPTU5vZGVQcm9wVHlwZSwgUmVmSG9sZGVyUHJvcFR5cGV9IGZyb20gJy4uL3Byb3AtdHlwZXMnO1xuaW1wb3J0IFJlZkhvbGRlciBmcm9tICcuLi9tb2RlbHMvcmVmLWhvbGRlcic7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIENvbW1hbmRzIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICByZWdpc3RyeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHRhcmdldDogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgRE9NTm9kZVByb3BUeXBlLFxuICAgICAgUmVmSG9sZGVyUHJvcFR5cGUsXG4gICAgXSkuaXNSZXF1aXJlZCxcbiAgICBjaGlsZHJlbjogUHJvcFR5cGVzLm9uZU9mVHlwZShbXG4gICAgICBQcm9wVHlwZXMuZWxlbWVudCxcbiAgICAgIFByb3BUeXBlcy5hcnJheU9mKFByb3BUeXBlcy5lbGVtZW50KSxcbiAgICBdKS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHtyZWdpc3RyeSwgdGFyZ2V0fSA9IHRoaXMucHJvcHM7XG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXY+XG4gICAgICAgIHtSZWFjdC5DaGlsZHJlbi5tYXAodGhpcy5wcm9wcy5jaGlsZHJlbiwgY2hpbGQgPT4ge1xuICAgICAgICAgIHJldHVybiBjaGlsZCA/IFJlYWN0LmNsb25lRWxlbWVudChjaGlsZCwge3JlZ2lzdHJ5LCB0YXJnZXR9KSA6IG51bGw7XG4gICAgICAgIH0pfVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgQ29tbWFuZCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgcmVnaXN0cnk6IFByb3BUeXBlcy5vYmplY3QsXG4gICAgdGFyZ2V0OiBQcm9wVHlwZXMub25lT2ZUeXBlKFtcbiAgICAgIFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBET01Ob2RlUHJvcFR5cGUsXG4gICAgICBSZWZIb2xkZXJQcm9wVHlwZSxcbiAgICBdKSxcbiAgICBjb21tYW5kOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgY2FsbGJhY2s6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcywgY29udGV4dCkge1xuICAgIHN1cGVyKHByb3BzLCBjb250ZXh0KTtcbiAgICB0aGlzLnN1YlRhcmdldCA9IG5ldyBEaXNwb3NhYmxlKCk7XG4gICAgdGhpcy5zdWJDb21tYW5kID0gbmV3IERpc3Bvc2FibGUoKTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIHRoaXMub2JzZXJ2ZVRhcmdldCh0aGlzLnByb3BzKTtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxSZWNlaXZlUHJvcHMobmV3UHJvcHMpIHtcbiAgICBpZiAoWydyZWdpc3RyeScsICd0YXJnZXQnLCAnY29tbWFuZCcsICdjYWxsYmFjayddLnNvbWUocCA9PiBuZXdQcm9wc1twXSAhPT0gdGhpcy5wcm9wc1twXSkpIHtcbiAgICAgIHRoaXMub2JzZXJ2ZVRhcmdldChuZXdQcm9wcyk7XG4gICAgfVxuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5zdWJUYXJnZXQuZGlzcG9zZSgpO1xuICAgIHRoaXMuc3ViQ29tbWFuZC5kaXNwb3NlKCk7XG4gIH1cblxuICBvYnNlcnZlVGFyZ2V0KHByb3BzKSB7XG4gICAgdGhpcy5zdWJUYXJnZXQuZGlzcG9zZSgpO1xuICAgIHRoaXMuc3ViVGFyZ2V0ID0gUmVmSG9sZGVyLm9uKHByb3BzLnRhcmdldCkub2JzZXJ2ZSh0ID0+IHRoaXMucmVnaXN0ZXJDb21tYW5kKHQsIHByb3BzKSk7XG4gIH1cblxuICByZWdpc3RlckNvbW1hbmQodGFyZ2V0LCB7cmVnaXN0cnksIGNvbW1hbmQsIGNhbGxiYWNrfSkge1xuICAgIHRoaXMuc3ViQ29tbWFuZC5kaXNwb3NlKCk7XG4gICAgdGhpcy5zdWJDb21tYW5kID0gcmVnaXN0cnkuYWRkKHRhcmdldCwgY29tbWFuZCwgY2FsbGJhY2spO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiBudWxsO1xuICB9XG59XG4iXX0=