'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextEditorContext = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const editorUpdateProps = {
  mini: _propTypes2.default.bool,
  readOnly: _propTypes2.default.bool,
  placeholderText: _propTypes2.default.string,
  lineNumberGutterVisible: _propTypes2.default.bool,
  autoHeight: _propTypes2.default.bool,
  autoWidth: _propTypes2.default.bool,
  softWrapped: _propTypes2.default.bool
};

const editorCreationProps = _extends({
  buffer: _propTypes2.default.object }, editorUpdateProps);

const TextEditorContext = exports.TextEditorContext = _react2.default.createContext();

class AtomTextEditor extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'observeSelections');

    this.subs = new _eventKit.CompositeDisposable();

    this.refParent = new _refHolder2.default();
    this.refElement = new _refHolder2.default();
    this.refModel = null;
  }

  render() {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement('div', { className: 'github-AtomTextEditor-container', ref: this.refParent.setter }),
      _react2.default.createElement(
        TextEditorContext.Provider,
        { value: this.getRefModel() },
        this.props.children
      )
    );
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);

    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.refElement.setter(editor.getElement());

      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections));

      return null;
    });
  }

  componentDidUpdate(prevProps) {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps));
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  observeSelections(selection) {
    const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
      selectionSubs.dispose();
      this.subs.remove(selectionSubs);
      this.props.didDestroySelection(selection);
    }));
    this.subs.add(selectionSubs);
    this.props.didAddSelection(selection);
  }

  contains(element) {
    return this.refElement.map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.refElement.map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder2.default();
    }

    return this.refModel;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }
}
exports.default = AtomTextEditor;
AtomTextEditor.propTypes = _extends({}, editorCreationProps, {

  workspace: _propTypes2.default.object.isRequired, // FIXME make more specific

  didChangeCursorPosition: _propTypes2.default.func,
  didAddSelection: _propTypes2.default.func,
  didChangeSelectionRange: _propTypes2.default.func,
  didDestroySelection: _propTypes2.default.func,
  observeSelections: _propTypes2.default.func,

  refModel: _propTypes3.RefHolderPropType,

  children: _propTypes2.default.node
});
AtomTextEditor.defaultProps = {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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