<!---
For community contributors -- Please fill out Part 1 of the following template. This will help our team collaborate with you and give us an opportunity to provide valuable feedback that could inform your development process. Sections in Part 2 are not mandatory to get the conversation started, but will help our team understand your vision better and allow us to give better feedback.
--->

**_Part 1 - Required information_**

# Feature title

## :tipping_hand_woman: Status

Proposed

## :memo: Summary

One paragraph explanation of the feature.

## :checkered_flag: Motivation

Why are we doing this? What use cases does it support? What is the expected outcome?

## 🤯 Explanation

Explain the proposal as if it was already implemented in the GitHub package and you were describing it to an Atom user. That generally means:

- Introducing new named concepts.
- Explaining the feature largely in terms of examples.
- Explaining any changes to existing workflows.
- Design mock-ups or diagrams depicting any new UI that will be introduced.


**_Part 2 - Additional information_**

## :anchor: Drawbacks

Why should we *not* do this?

## :thinking: Rationale and alternatives

- Why is this approach the best in the space of possible approaches?
- What other approaches have been considered and what is the rationale for not choosing them?
- What is the impact of not doing this?

## :question: Unresolved questions

- What unresolved questions do you expect to resolve through the Feature Request process before this gets merged?
- What unresolved questions do you expect to resolve through the implementation of this feature before it is released in a new version of the package?

## :warning: Out of Scope

- What related issues do you consider out of scope for this Feature Request that could be addressed in the future independently of the solution that comes out of this Feature Request?

## :construction: Implementation phases

- Can this functionality be introduced in multiple, distinct, self-contained pull requests?
- A specification for when the feature is considered "done."

## :white_check_mark: Feature description for Atom release blog post

- When this feature is shipped, what would we like to say or show in our Atom release blog post (example: http://blog.atom.io/2018/07/31/atom-1-29.html)
- Feel free to drop ideas and gifs here during development
- Once development is complete, write a blurb for the release coordinator to copy/paste into the Atom release blog
