(function() {
  var _, escapeHtml, escapeNode, escapeRegex, getReplacementResultsMessage, getSearchResultsMessage, sanitizePattern, showIf;

  _ = require('underscore-plus');

  escapeNode = null;

  escapeHtml = function(str) {
    if (escapeNode == null) {
      escapeNode = document.createElement('div');
    }
    escapeNode.innerText = str;
    return escapeNode.innerHTML;
  };

  escapeRegex = function(str) {
    return str.replace(/[.?*+^$[\]\\(){}|-]/g, function(match) {
      return "\\" + match;
    });
  };

  sanitizePattern = function(pattern) {
    pattern = escapeHtml(pattern);
    return pattern.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
  };

  getReplacementResultsMessage = function(arg) {
    var findPattern, replacePattern, replacedPathCount, replacementCount;
    findPattern = arg.findPattern, replacePattern = arg.replacePattern, replacedPathCount = arg.replacedPathCount, replacementCount = arg.replacementCount;
    if (replacedPathCount) {
      return "<span class=\"text-highlight\">Replaced <span class=\"highlight-error\">" + (sanitizePattern(findPattern)) + "</span> with <span class=\"highlight-success\">" + (sanitizePattern(replacePattern)) + "</span> " + (_.pluralize(replacementCount, 'time')) + " in " + (_.pluralize(replacedPathCount, 'file')) + "</span>";
    } else {
      return "<span class=\"text-highlight\">Nothing replaced</span>";
    }
  };

  getSearchResultsMessage = function(results) {
    var findPattern, matchCount, pathCount, replacedPathCount;
    if ((results != null ? results.findPattern : void 0) != null) {
      findPattern = results.findPattern, matchCount = results.matchCount, pathCount = results.pathCount, replacedPathCount = results.replacedPathCount;
      if (matchCount) {
        return (_.pluralize(matchCount, 'result')) + " found in " + (_.pluralize(pathCount, 'file')) + " for <span class=\"highlight-info\">" + (sanitizePattern(findPattern)) + "</span>";
      } else {
        return "No " + (replacedPathCount != null ? 'more' : '') + " results found for '" + (sanitizePattern(findPattern)) + "'";
      }
    } else {
      return '';
    }
  };

  showIf = function(condition) {
    if (condition) {
      return null;
    } else {
      return {
        display: 'none'
      };
    }
  };

  module.exports = {
    escapeHtml: escapeHtml,
    escapeRegex: escapeRegex,
    sanitizePattern: sanitizePattern,
    getReplacementResultsMessage: getReplacementResultsMessage,
    getSearchResultsMessage: getSearchResultsMessage,
    showIf: showIf
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
