(function() {
  var BufferSearch, CompositeDisposable, Disposable, FindOptions, FindView, History, HistoryCycler, ProjectFindView, ResultsModel, ResultsPaneView, SelectNext, TextBuffer, getIconServices, ref, ref1;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, TextBuffer = ref.TextBuffer;

  SelectNext = require('./select-next');

  ref1 = require('./history'), History = ref1.History, HistoryCycler = ref1.HistoryCycler;

  FindOptions = require('./find-options');

  BufferSearch = require('./buffer-search');

  getIconServices = require('./get-icon-services');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  module.exports = {
    activate: function(arg) {
      var findHistory, findOptions, handleEditorCancel, pathsHistory, ref2, replaceHistory, selectNextObjectForEditorElement, showPanel, togglePanel;
      ref2 = arg != null ? arg : {}, findOptions = ref2.findOptions, findHistory = ref2.findHistory, replaceHistory = ref2.replaceHistory, pathsHistory = ref2.pathsHistory;
      if (atom.config.get('find-and-replace.openProjectFindResultsInRightPane')) {
        atom.config.set('find-and-replace.projectSearchResultsPaneSplitDirection', 'right');
      }
      atom.config.unset('find-and-replace.openProjectFindResultsInRightPane');
      atom.workspace.addOpener(function(filePath) {
        if (filePath === ResultsPaneView.URI) {
          return new ResultsPaneView();
        }
      });
      this.subscriptions = new CompositeDisposable;
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.findOptions = new FindOptions(findOptions);
      this.findModel = new BufferSearch(this.findOptions);
      this.resultsModel = new ResultsModel(this.findOptions);
      this.subscriptions.add(atom.workspace.getCenter().observeActivePaneItem((function(_this) {
        return function(paneItem) {
          if (paneItem != null ? typeof paneItem.getBuffer === "function" ? paneItem.getBuffer() : void 0 : void 0) {
            return _this.findModel.setEditor(paneItem);
          } else {
            return _this.findModel.setEditor(null);
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('.find-and-replace, .project-find', 'window:focus-next-pane', function() {
        return atom.views.getView(atom.workspace).focus();
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.projectFindPanel, _this.findPanel, function() {
            return _this.projectFindView.focusFindElement();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(arg1) {
          var target;
          target = arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          _this.projectFindView.focusFindElement();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var ref3, ref4;
          if (((ref3 = _this.projectFindPanel) != null ? ref3.isVisible() : void 0) || ((ref4 = _this.findPanel) != null ? ref4.isVisible() : void 0)) {
            return;
          }
          return _this.createViews();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          return togglePanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusFindEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          _this.createViews();
          return showPanel(_this.findPanel, _this.projectFindPanel, function() {
            return _this.findView.focusReplaceEditor();
          });
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:clear-history', (function(_this) {
        return function() {
          _this.findHistory.clear();
          return _this.replaceHistory.clear();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(arg1) {
          var isMiniEditor, ref3, ref4, target;
          target = arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((ref3 = _this.findPanel) != null) {
              ref3.hide();
            }
            return (ref4 = _this.projectFindPanel) != null ? ref4.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      showPanel = function(panelToShow, panelToHide, postShowAction) {
        panelToHide.hide();
        panelToShow.show();
        return typeof postShowAction === "function" ? postShowAction() : void 0;
      };
      togglePanel = function(panelToToggle, panelToHide, postToggleAction) {
        panelToHide.hide();
        if (panelToToggle.isVisible()) {
          return panelToToggle.hide();
        } else {
          panelToToggle.show();
          return typeof postToggleAction === "function" ? postToggleAction() : void 0;
        }
      };
      return this.subscriptions.add(atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      }));
    },
    consumeElementIcons: function(service) {
      getIconServices().setElementIcons(service);
      return new Disposable(function() {
        return getIconServices().resetElementIcons();
      });
    },
    consumeFileIcons: function(service) {
      getIconServices().setFileIcons(service);
      return new Disposable(function() {
        return getIconServices().resetFileIcons();
      });
    },
    toggleAutocompletions: function(value) {
      var disposable, ref2;
      if (this.findView == null) {
        return;
      }
      if (value) {
        this.autocompleteSubscriptions = new CompositeDisposable;
        disposable = typeof this.autocompleteWatchEditor === "function" ? this.autocompleteWatchEditor(this.findView.findEditor, ['default']) : void 0;
        if (disposable != null) {
          return this.autocompleteSubscriptions.add(disposable);
        }
      } else {
        return (ref2 = this.autocompleteSubscriptions) != null ? ref2.dispose() : void 0;
      }
    },
    consumeAutocompleteWatchEditor: function(watchEditor) {
      this.autocompleteWatchEditor = watchEditor;
      atom.config.observe('find-and-replace.autocompleteSearches', (function(_this) {
        return function(value) {
          return _this.toggleAutocompletions(value);
        };
      })(this));
      return new Disposable((function(_this) {
        return function() {
          var ref2;
          if ((ref2 = _this.autocompleteSubscriptions) != null) {
            ref2.dispose();
          }
          return _this.autocompleteWatchEditor = null;
        };
      })(this));
    },
    provideService: function() {
      return {
        resultsMarkerLayerForTextEditor: this.findModel.resultsMarkerLayerForTextEditor.bind(this.findModel)
      };
    },
    createViews: function() {
      var findBuffer, findHistoryCycler, options, pathsBuffer, pathsHistoryCycler, replaceBuffer, replaceHistoryCycler;
      if (this.findView != null) {
        return;
      }
      findBuffer = new TextBuffer;
      replaceBuffer = new TextBuffer;
      pathsBuffer = new TextBuffer;
      findHistoryCycler = new HistoryCycler(findBuffer, this.findHistory);
      replaceHistoryCycler = new HistoryCycler(replaceBuffer, this.replaceHistory);
      pathsHistoryCycler = new HistoryCycler(pathsBuffer, this.pathsHistory);
      options = {
        findBuffer: findBuffer,
        replaceBuffer: replaceBuffer,
        pathsBuffer: pathsBuffer,
        findHistoryCycler: findHistoryCycler,
        replaceHistoryCycler: replaceHistoryCycler,
        pathsHistoryCycler: pathsHistoryCycler
      };
      this.findView = new FindView(this.findModel, options);
      this.projectFindView = new ProjectFindView(this.resultsModel, options);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      ResultsPaneView.model = this.resultsModel;
      return this.toggleAutocompletions(atom.config.get('find-and-replace.autocompleteSearches'));
    },
    deactivate: function() {
      var ref2, ref3, ref4, ref5, ref6, ref7, ref8;
      if ((ref2 = this.findPanel) != null) {
        ref2.destroy();
      }
      this.findPanel = null;
      if ((ref3 = this.findView) != null) {
        ref3.destroy();
      }
      this.findView = null;
      if ((ref4 = this.findModel) != null) {
        ref4.destroy();
      }
      this.findModel = null;
      if ((ref5 = this.projectFindPanel) != null) {
        ref5.destroy();
      }
      this.projectFindPanel = null;
      if ((ref6 = this.projectFindView) != null) {
        ref6.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      this.resultsModel = null;
      if ((ref7 = this.autocompleteSubscriptions) != null) {
        ref7.dispose();
      }
      this.autocompleteManagerService = null;
      if ((ref8 = this.subscriptions) != null) {
        ref8.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      return {
        findOptions: this.findOptions.serialize(),
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.pathsHistory.serialize()
      };
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
