function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    if (atom.inDevMode()) {
      return [];
    }

    var duplicatePackages = [];
    var names = atom.packages.getAvailablePackageNames();
    for (var _name of names) {
      if (atom.packages.isBundledPackage(_name)) {
        var isDuplicatedPackage = yield this.isInstalledAsCommunityPackage(_name);
        if (isDuplicatedPackage) {
          duplicatePackages.push(_name);
        }
      }
    }

    return duplicatePackages;
  }),

  isInstalledAsCommunityPackage: _asyncToGenerator(function* (name) {
    var availablePackagePaths = atom.packages.getPackageDirPaths();

    for (var packagePath of availablePackagePaths) {
      var candidate = path.join(packagePath, name);

      if (fs.existsSync(candidate)) {
        var realPath = yield this.realpath(candidate);
        if (realPath === candidate) {
          return true;
        }
      }
    }

    return false;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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