Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _humanizePlus = require('humanize-plus');

var _humanizePlus2 = _interopRequireDefault(_humanizePlus);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _directoryView = require('./directory-view');

var _directoryView2 = _interopRequireDefault(_directoryView);

var ArchiveEditorView = (function () {
  function ArchiveEditorView(archivePath) {
    var _this = this;

    _classCallCheck(this, ArchiveEditorView);

    this.disposables = new _atom.CompositeDisposable();
    this.emitter = new _atom.Emitter();
    this.path = archivePath;
    this.file = new _atom.File(this.path);
    this.entries = [];
    _etch2['default'].initialize(this);

    this.refresh();

    this.disposables.add(this.file.onDidChange(function () {
      return _this.refresh();
    }));
    this.disposables.add(this.file.onDidRename(function () {
      return _this.refresh();
    }));
    this.disposables.add(this.file.onDidDelete(function () {
      return _this.destroy();
    }));

    var focusHandler = function focusHandler() {
      return _this.focusSelectedFile();
    };

    this.element.addEventListener('focus', focusHandler);
    this.disposables.add(new _atom.Disposable(function () {
      return _this.element.removeEventListener('focus', focusHandler);
    }));
  }

  _createClass(ArchiveEditorView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'archive-editor', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'archive-container' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'padded icon icon-hourglass text-info' },
            'Loading archive…'
          ),
          _etch2['default'].dom('div', { ref: 'errorMessage', className: 'padded icon icon-alert text-error' }),
          _etch2['default'].dom(
            'div',
            { className: 'inset-panel' },
            _etch2['default'].dom('div', { ref: 'summary', className: 'panel-heading' }),
            _etch2['default'].dom('ol', { ref: 'tree', className: 'archive-tree padded list-tree has-collapsable-children' })
          )
        )
      );
    }
  }, {
    key: 'copy',
    value: function copy() {
      return new ArchiveEditorView(this.path);
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }
      this.disposables.dispose();
      this.emitter.emit('did-destroy');
      _etch2['default'].destroy(this);
    }
  }, {
    key: 'onDidDestroy',
    value: function onDidDestroy(callback) {
      return this.emitter.on('did-destroy', callback);
    }
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle(callback) {
      return this.emitter.on('did-change-title', callback);
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        path: this.path
      };
    }
  }, {
    key: 'getPath',
    value: function getPath() {
      return this.file.getPath();
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return this.path ? this.file.getBaseName() : 'untitled';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.path;
    }
  }, {
    key: 'refresh',
    value: function refresh() {
      var _this2 = this;

      this.refs.summary.style.display = 'none';
      this.refs.tree.style.display = 'none';
      this.refs.loadingMessage.style.display = '';
      this.refs.errorMessage.style.display = 'none';

      if (this.path !== this.getPath()) {
        this.path = this.getPath();
        this.emitter.emit('did-change-title');
      }

      var originalPath = this.path;
      _lsArchive2['default'].list(this.path, { tree: true }, function (error, entries) {
        if (originalPath !== _this2.path) {
          return;
        }

        if (error != null) {
          var message = 'Reading the archive file failed';
          if (error.message) {
            message += ': ' + error.message;
          }
          _this2.refs.errorMessage.style.display = '';
          _this2.refs.errorMessage.textContent = message;
        } else {
          _this2.createTreeEntries(entries);
          _this2.updateSummary();
        }

        // We hide the loading message _after_ creating the archive tree
        // to avoid forced reflows.
        _this2.refs.loadingMessage.style.display = 'none';
      });
    }
  }, {
    key: 'createTreeEntries',
    value: function createTreeEntries(entries) {
      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      var index = 0;
      for (var entry of entries) {
        if (entry.isDirectory()) {
          var entryView = new _directoryView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
        } else {
          var entryView = new _fileView2['default'](this, index, this.path, entry);
          this.entries.push(entryView);
        }
        index++;
      }

      this.selectFileAfterIndex(-1);

      // Wait until selecting (focusing) the first file before appending the entries
      // to avoid a double-forced reflow when focusing.
      for (var entry of this.entries) {
        this.refs.tree.appendChild(entry.element);
      }

      this.refs.tree.style.display = '';
    }
  }, {
    key: 'updateSummary',
    value: function updateSummary() {
      var fileCount = this.entries.filter(function (entry) {
        return entry instanceof _fileView2['default'];
      }).length;
      var fileLabel = fileCount === 1 ? '1 file' : _humanizePlus2['default'].intComma(fileCount) + ' files';

      var directoryCount = this.entries.filter(function (entry) {
        return entry instanceof _directoryView2['default'];
      }).length;
      var directoryLabel = directoryCount === 1 ? '1 folder' : _humanizePlus2['default'].intComma(directoryCount) + ' folders';

      this.refs.summary.style.display = '';
      this.refs.summary.textContent = _humanizePlus2['default'].fileSize(_fsPlus2['default'].getSizeSync(this.path)) + ' with ' + fileLabel + ' and ' + directoryLabel;
    }
  }, {
    key: 'focusSelectedFile',
    value: function focusSelectedFile() {
      var selectedFile = this.refs.tree.querySelector('.selected');
      if (selectedFile) {
        selectedFile.focus();
      }
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          break;
        } else {
          if (previousEntry.selectLastFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          break;
        } else {
          if (nextEntry.selectFirstFile()) {
            break;
          }
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.focusSelectedFile();
    }
  }]);

  return ArchiveEditorView;
})();

exports['default'] = ArchiveEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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